@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the Machine Extension Instance View.
 * @property name The machine extension name.
 * @property status Instance view status.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class MachineExtensionInstanceViewResponse(
    public val name: String? = null,
    public val status: MachineExtensionInstanceViewResponseStatus? = null,
    public val type: String? = null,
    public val typeHandlerVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.MachineExtensionInstanceViewResponse): MachineExtensionInstanceViewResponse = MachineExtensionInstanceViewResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineExtensionInstanceViewResponseStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            typeHandlerVersion = javaType.typeHandlerVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
