@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the operating system settings for the hybrid machine.
 * @property computerName Specifies the host OS name of the hybrid machine.
 * @property linuxConfiguration Specifies the linux configuration for update management.
 * @property windowsConfiguration Specifies the windows configuration for update management.
 */
public data class OSProfileResponse(
    public val computerName: String,
    public val linuxConfiguration: OSProfileResponseLinuxConfiguration? = null,
    public val windowsConfiguration: OSProfileResponseWindowsConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.OSProfileResponse): OSProfileResponse = OSProfileResponse(
            computerName = javaType.computerName(),
            linuxConfiguration = javaType.linuxConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.OSProfileResponseLinuxConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            windowsConfiguration = javaType.windowsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.OSProfileResponseWindowsConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
