@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the linux configuration for update management.
 * @property assessmentMode Specifies the assessment mode.
 * @property patchMode Specifies the patch mode.
 */
public data class OSProfileResponseLinuxConfiguration(
    public val assessmentMode: String? = null,
    public val patchMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.OSProfileResponseLinuxConfiguration): OSProfileResponseLinuxConfiguration = OSProfileResponseLinuxConfiguration(
            assessmentMode = javaType.assessmentMode().map({ args0 -> args0 }).orElse(null),
            patchMode = javaType.patchMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
