@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Data Model for a Private Endpoint Connection associated with a Private Link Scope
 * @property id The ARM Resource Id of the Private Endpoint.
 * @property name The Name of the Private Endpoint.
 * @property properties The Private Endpoint Connection properties.
 * @property type Azure resource type
 */
public data class PrivateEndpointConnectionDataModelResponse(
    public val id: String,
    public val name: String,
    public val properties: PrivateEndpointConnectionPropertiesResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.PrivateEndpointConnectionDataModelResponse): PrivateEndpointConnectionDataModelResponse = PrivateEndpointConnectionDataModelResponse(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.PrivateEndpointConnectionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
