@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * State of the private endpoint connection.
 * @property actionsRequired The actions required for private link service connection.
 * @property description The private link service connection description.
 * @property status The private link service connection status.
 */
public data class PrivateLinkServiceConnectionStatePropertyResponse(
    public val actionsRequired: String,
    public val description: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.PrivateLinkServiceConnectionStatePropertyResponse): PrivateLinkServiceConnectionStatePropertyResponse =
            PrivateLinkServiceConnectionStatePropertyResponse(
                actionsRequired = javaType.actionsRequired(),
                description = javaType.description(),
                status = javaType.status(),
            )
    }
}
