@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin

import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.EndpointPropertiesResponse
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.EndpointPropertiesResponse.Companion.toKotlin as endpointPropertiesResponseToKotlin
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Endpoint].
 */
@PulumiTagMarker
public class EndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointArgs = EndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointArgsBuilder.() -> Unit) {
        val builder = EndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Endpoint {
        val builtJavaResource =
            com.pulumi.azurenative.hybridconnectivity.Endpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Endpoint(builtJavaResource)
    }
}

/**
 * The endpoint for the target resource.
 * Azure REST API version: 2023-03-15. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * Other available API versions: 2022-05-01-preview.
 * ## Example Usage
 * ### HybridConnectivityEndpointsPutCustom
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.HybridConnectivity.Endpoint("endpoint", new()
 *     {
 *         EndpointName = "custom",
 *         Properties = new AzureNative.HybridConnectivity.Inputs.EndpointPropertiesArgs
 *         {
 *             ResourceId = "/subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.Relay/namespaces/custom-relay-namespace",
 *             Type = AzureNative.HybridConnectivity.Type.Custom,
 *         },
 *         ResourceUri = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridconnectivity/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridconnectivity.NewEndpoint(ctx, "endpoint", &hybridconnectivity.EndpointArgs{
 * 			EndpointName: pulumi.String("custom"),
 * 			Properties: &hybridconnectivity.EndpointPropertiesArgs{
 * 				ResourceId: pulumi.String("/subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.Relay/namespaces/custom-relay-namespace"),
 * 				Type:       pulumi.String(hybridconnectivity.TypeCustom),
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridconnectivity.Endpoint;
 * import com.pulumi.azurenative.hybridconnectivity.EndpointArgs;
 * import com.pulumi.azurenative.hybridconnectivity.inputs.EndpointPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .endpointName("custom")
 *             .properties(EndpointPropertiesArgs.builder()
 *                 .resourceId("/subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.Relay/namespaces/custom-relay-namespace")
 *                 .type("custom")
 *                 .build())
 *             .resourceUri("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine")
 *             .build());
 *     }
 * }
 * ```
 * ### HybridConnectivityEndpointsPutDefault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.HybridConnectivity.Endpoint("endpoint", new()
 *     {
 *         EndpointName = "default",
 *         Properties = new AzureNative.HybridConnectivity.Inputs.EndpointPropertiesArgs
 *         {
 *             Type = AzureNative.HybridConnectivity.Type.@Default,
 *         },
 *         ResourceUri = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridconnectivity/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridconnectivity.NewEndpoint(ctx, "endpoint", &hybridconnectivity.EndpointArgs{
 * 			EndpointName: pulumi.String("default"),
 * 			Properties: &hybridconnectivity.EndpointPropertiesArgs{
 * 				Type: pulumi.String(hybridconnectivity.TypeDefault),
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridconnectivity.Endpoint;
 * import com.pulumi.azurenative.hybridconnectivity.EndpointArgs;
 * import com.pulumi.azurenative.hybridconnectivity.inputs.EndpointPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .endpointName("default")
 *             .properties(EndpointPropertiesArgs.builder()
 *                 .type("default")
 *                 .build())
 *             .resourceUri("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridconnectivity:Endpoint default /{resourceUri}/providers/Microsoft.HybridConnectivity/endpoints/{endpointName}
 * ```
 */
public class Endpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridconnectivity.Endpoint,
) : KotlinCustomResource(javaResource, EndpointMapper) {
    /**
     * The timestamp of resource creation (UTC).
     */
    public val createdAt: Output<String>?
        get() = javaResource.createdAt().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The identity that created the resource.
     */
    public val createdBy: Output<String>?
        get() = javaResource.createdBy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of identity that created the resource.
     */
    public val createdByType: Output<String>?
        get() = javaResource.createdByType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The timestamp of resource last modification (UTC)
     */
    public val lastModifiedAt: Output<String>?
        get() = javaResource.lastModifiedAt().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identity that last modified the resource.
     */
    public val lastModifiedBy: Output<String>?
        get() = javaResource.lastModifiedBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of identity that last modified the resource.
     */
    public val lastModifiedByType: Output<String>?
        get() = javaResource.lastModifiedByType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The endpoint properties.
     */
    public val properties: Output<EndpointPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                endpointPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EndpointMapper : ResourceMapper<Endpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridconnectivity.Endpoint::class == javaResource::class

    override fun map(javaResource: Resource): Endpoint = Endpoint(
        javaResource as
            com.pulumi.azurenative.hybridconnectivity.Endpoint,
    )
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Endpoint].
 */
public suspend fun endpoint(name: String, block: suspend EndpointResourceBuilder.() -> Unit): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpoint(name: String): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
