@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin

import com.pulumi.azurenative.hybridconnectivity.EndpointArgs.builder
import com.pulumi.azurenative.hybridconnectivity.kotlin.enums.CreatedByType
import com.pulumi.azurenative.hybridconnectivity.kotlin.inputs.EndpointPropertiesArgs
import com.pulumi.azurenative.hybridconnectivity.kotlin.inputs.EndpointPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The endpoint for the target resource.
 * Azure REST API version: 2023-03-15. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * Other available API versions: 2022-05-01-preview.
 * ## Example Usage
 * ### HybridConnectivityEndpointsPutCustom
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.HybridConnectivity.Endpoint("endpoint", new()
 *     {
 *         EndpointName = "custom",
 *         Properties = new AzureNative.HybridConnectivity.Inputs.EndpointPropertiesArgs
 *         {
 *             ResourceId = "/subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.Relay/namespaces/custom-relay-namespace",
 *             Type = AzureNative.HybridConnectivity.Type.Custom,
 *         },
 *         ResourceUri = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridconnectivity/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridconnectivity.NewEndpoint(ctx, "endpoint", &hybridconnectivity.EndpointArgs{
 * 			EndpointName: pulumi.String("custom"),
 * 			Properties: &hybridconnectivity.EndpointPropertiesArgs{
 * 				ResourceId: pulumi.String("/subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.Relay/namespaces/custom-relay-namespace"),
 * 				Type:       pulumi.String(hybridconnectivity.TypeCustom),
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridconnectivity.Endpoint;
 * import com.pulumi.azurenative.hybridconnectivity.EndpointArgs;
 * import com.pulumi.azurenative.hybridconnectivity.inputs.EndpointPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .endpointName("custom")
 *             .properties(EndpointPropertiesArgs.builder()
 *                 .resourceId("/subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.Relay/namespaces/custom-relay-namespace")
 *                 .type("custom")
 *                 .build())
 *             .resourceUri("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine")
 *             .build());
 *     }
 * }
 * ```
 * ### HybridConnectivityEndpointsPutDefault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.HybridConnectivity.Endpoint("endpoint", new()
 *     {
 *         EndpointName = "default",
 *         Properties = new AzureNative.HybridConnectivity.Inputs.EndpointPropertiesArgs
 *         {
 *             Type = AzureNative.HybridConnectivity.Type.@Default,
 *         },
 *         ResourceUri = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridconnectivity/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridconnectivity.NewEndpoint(ctx, "endpoint", &hybridconnectivity.EndpointArgs{
 * 			EndpointName: pulumi.String("default"),
 * 			Properties: &hybridconnectivity.EndpointPropertiesArgs{
 * 				Type: pulumi.String(hybridconnectivity.TypeDefault),
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridconnectivity.Endpoint;
 * import com.pulumi.azurenative.hybridconnectivity.EndpointArgs;
 * import com.pulumi.azurenative.hybridconnectivity.inputs.EndpointPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .endpointName("default")
 *             .properties(EndpointPropertiesArgs.builder()
 *                 .type("default")
 *                 .build())
 *             .resourceUri("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridconnectivity:Endpoint default /{resourceUri}/providers/Microsoft.HybridConnectivity/endpoints/{endpointName}
 * ```
 * @property createdAt The timestamp of resource creation (UTC).
 * @property createdBy The identity that created the resource.
 * @property createdByType The type of identity that created the resource.
 * @property endpointName The endpoint name.
 * @property lastModifiedAt The timestamp of resource last modification (UTC)
 * @property lastModifiedBy The identity that last modified the resource.
 * @property lastModifiedByType The type of identity that last modified the resource.
 * @property properties The endpoint properties.
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
 */
public data class EndpointArgs(
    public val createdAt: Output<String>? = null,
    public val createdBy: Output<String>? = null,
    public val createdByType: Output<Either<String, CreatedByType>>? = null,
    public val endpointName: Output<String>? = null,
    public val lastModifiedAt: Output<String>? = null,
    public val lastModifiedBy: Output<String>? = null,
    public val lastModifiedByType: Output<Either<String, CreatedByType>>? = null,
    public val properties: Output<EndpointPropertiesArgs>? = null,
    public val resourceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridconnectivity.EndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridconnectivity.EndpointArgs =
        com.pulumi.azurenative.hybridconnectivity.EndpointArgs.builder()
            .createdAt(createdAt?.applyValue({ args0 -> args0 }))
            .createdBy(createdBy?.applyValue({ args0 -> args0 }))
            .createdByType(
                createdByType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .lastModifiedAt(lastModifiedAt?.applyValue({ args0 -> args0 }))
            .lastModifiedBy(lastModifiedBy?.applyValue({ args0 -> args0 }))
            .lastModifiedByType(
                lastModifiedByType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var createdAt: Output<String>? = null

    private var createdBy: Output<String>? = null

    private var createdByType: Output<Either<String, CreatedByType>>? = null

    private var endpointName: Output<String>? = null

    private var lastModifiedAt: Output<String>? = null

    private var lastModifiedBy: Output<String>? = null

    private var lastModifiedByType: Output<Either<String, CreatedByType>>? = null

    private var properties: Output<EndpointPropertiesArgs>? = null

    private var resourceUri: Output<String>? = null

    /**
     * @param value The timestamp of resource creation (UTC).
     */
    @JvmName("sdyxivgumbtmmwvj")
    public suspend fun createdAt(`value`: Output<String>) {
        this.createdAt = value
    }

    /**
     * @param value The identity that created the resource.
     */
    @JvmName("evqwtcarmgtvjyrl")
    public suspend fun createdBy(`value`: Output<String>) {
        this.createdBy = value
    }

    /**
     * @param value The type of identity that created the resource.
     */
    @JvmName("ndpmbochhtnccope")
    public suspend fun createdByType(`value`: Output<Either<String, CreatedByType>>) {
        this.createdByType = value
    }

    /**
     * @param value The endpoint name.
     */
    @JvmName("ddfnnygpatmafibb")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value The timestamp of resource last modification (UTC)
     */
    @JvmName("mnjogvslnhssqwfk")
    public suspend fun lastModifiedAt(`value`: Output<String>) {
        this.lastModifiedAt = value
    }

    /**
     * @param value The identity that last modified the resource.
     */
    @JvmName("bvesuruespfavmmj")
    public suspend fun lastModifiedBy(`value`: Output<String>) {
        this.lastModifiedBy = value
    }

    /**
     * @param value The type of identity that last modified the resource.
     */
    @JvmName("atlxjgxsaktntyqy")
    public suspend fun lastModifiedByType(`value`: Output<Either<String, CreatedByType>>) {
        this.lastModifiedByType = value
    }

    /**
     * @param value The endpoint properties.
     */
    @JvmName("drpxdhjmiiatlydn")
    public suspend fun properties(`value`: Output<EndpointPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource to be connected.
     */
    @JvmName("outoscefksfejxta")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value The timestamp of resource creation (UTC).
     */
    @JvmName("aishmicooamowuav")
    public suspend fun createdAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdAt = mapped
    }

    /**
     * @param value The identity that created the resource.
     */
    @JvmName("srbggtqmpqjoprhh")
    public suspend fun createdBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdBy = mapped
    }

    /**
     * @param value The type of identity that created the resource.
     */
    @JvmName("itesxxwsfqwvnala")
    public suspend fun createdByType(`value`: Either<String, CreatedByType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdByType = mapped
    }

    /**
     * @param value The type of identity that created the resource.
     */
    @JvmName("nghqtrjbjjmxlowg")
    public fun createdByType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreatedByType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createdByType = mapped
    }

    /**
     * @param value The type of identity that created the resource.
     */
    @JvmName("jfpsvduurnjgnouu")
    public fun createdByType(`value`: CreatedByType) {
        val toBeMapped = Either.ofRight<String, CreatedByType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createdByType = mapped
    }

    /**
     * @param value The endpoint name.
     */
    @JvmName("jllrpnepwrlmvjcj")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value The timestamp of resource last modification (UTC)
     */
    @JvmName("yjylidvmgtvpejxi")
    public suspend fun lastModifiedAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedAt = mapped
    }

    /**
     * @param value The identity that last modified the resource.
     */
    @JvmName("gkwoyxhgapfgowgl")
    public suspend fun lastModifiedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedBy = mapped
    }

    /**
     * @param value The type of identity that last modified the resource.
     */
    @JvmName("sypongvamblmsyni")
    public suspend fun lastModifiedByType(`value`: Either<String, CreatedByType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedByType = mapped
    }

    /**
     * @param value The type of identity that last modified the resource.
     */
    @JvmName("pdlcdugtllxsnmrf")
    public fun lastModifiedByType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreatedByType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lastModifiedByType = mapped
    }

    /**
     * @param value The type of identity that last modified the resource.
     */
    @JvmName("cgycvdixqgnfirvu")
    public fun lastModifiedByType(`value`: CreatedByType) {
        val toBeMapped = Either.ofRight<String, CreatedByType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lastModifiedByType = mapped
    }

    /**
     * @param value The endpoint properties.
     */
    @JvmName("yirybdcamxgfyrug")
    public suspend fun properties(`value`: EndpointPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The endpoint properties.
     */
    @JvmName("cxcxuyscxwsvbtso")
    public suspend fun properties(argument: suspend EndpointPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource to be connected.
     */
    @JvmName("dxbetyktellgejki")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        createdAt = createdAt,
        createdBy = createdBy,
        createdByType = createdByType,
        endpointName = endpointName,
        lastModifiedAt = lastModifiedAt,
        lastModifiedBy = lastModifiedBy,
        lastModifiedByType = lastModifiedByType,
        properties = properties,
        resourceUri = resourceUri,
    )
}
