@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin

import com.pulumi.azurenative.hybridconnectivity.HybridconnectivityFunctions.getEndpointPlain
import com.pulumi.azurenative.hybridconnectivity.HybridconnectivityFunctions.getServiceConfigurationPlain
import com.pulumi.azurenative.hybridconnectivity.HybridconnectivityFunctions.listEndpointCredentialsPlain
import com.pulumi.azurenative.hybridconnectivity.HybridconnectivityFunctions.listEndpointIngressGatewayCredentialsPlain
import com.pulumi.azurenative.hybridconnectivity.HybridconnectivityFunctions.listEndpointManagedProxyDetailsPlain
import com.pulumi.azurenative.hybridconnectivity.kotlin.enums.ServiceName
import com.pulumi.azurenative.hybridconnectivity.kotlin.inputs.GetEndpointPlainArgs
import com.pulumi.azurenative.hybridconnectivity.kotlin.inputs.GetEndpointPlainArgsBuilder
import com.pulumi.azurenative.hybridconnectivity.kotlin.inputs.GetServiceConfigurationPlainArgs
import com.pulumi.azurenative.hybridconnectivity.kotlin.inputs.GetServiceConfigurationPlainArgsBuilder
import com.pulumi.azurenative.hybridconnectivity.kotlin.inputs.ListEndpointCredentialsPlainArgs
import com.pulumi.azurenative.hybridconnectivity.kotlin.inputs.ListEndpointCredentialsPlainArgsBuilder
import com.pulumi.azurenative.hybridconnectivity.kotlin.inputs.ListEndpointIngressGatewayCredentialsPlainArgs
import com.pulumi.azurenative.hybridconnectivity.kotlin.inputs.ListEndpointIngressGatewayCredentialsPlainArgsBuilder
import com.pulumi.azurenative.hybridconnectivity.kotlin.inputs.ListEndpointManagedProxyDetailsPlainArgs
import com.pulumi.azurenative.hybridconnectivity.kotlin.inputs.ListEndpointManagedProxyDetailsPlainArgsBuilder
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.GetEndpointResult
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.GetServiceConfigurationResult
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.ListEndpointCredentialsResult
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.ListEndpointIngressGatewayCredentialsResult
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.ListEndpointManagedProxyDetailsResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.GetEndpointResult.Companion.toKotlin as getEndpointResultToKotlin
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.GetServiceConfigurationResult.Companion.toKotlin as getServiceConfigurationResultToKotlin
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.ListEndpointCredentialsResult.Companion.toKotlin as listEndpointCredentialsResultToKotlin
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.ListEndpointIngressGatewayCredentialsResult.Companion.toKotlin as listEndpointIngressGatewayCredentialsResultToKotlin
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.ListEndpointManagedProxyDetailsResult.Companion.toKotlin as listEndpointManagedProxyDetailsResultToKotlin

public object HybridconnectivityFunctions {
    /**
     * Gets the endpoint to the resource.
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2022-05-01-preview.
     * @param argument null
     * @return The endpoint for the target resource.
     */
    public suspend fun getEndpoint(argument: GetEndpointPlainArgs): GetEndpointResult =
        getEndpointResultToKotlin(getEndpointPlain(argument.toJava()).await())

    /**
     * @see [getEndpoint].
     * @param endpointName The endpoint name.
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
     * @return The endpoint for the target resource.
     */
    public suspend fun getEndpoint(endpointName: String, resourceUri: String): GetEndpointResult {
        val argument = GetEndpointPlainArgs(
            endpointName = endpointName,
            resourceUri = resourceUri,
        )
        return getEndpointResultToKotlin(getEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridconnectivity&#46;kotlin&#46;inputs&#46;GetEndpointPlainArgs].
     * @return The endpoint for the target resource.
     */
    public suspend fun getEndpoint(argument: suspend GetEndpointPlainArgsBuilder.() -> Unit): GetEndpointResult {
        val builder = GetEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndpointResultToKotlin(getEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details about the service to the resource.
     * Azure REST API version: 2023-03-15.
     * @param argument null
     * @return The service configuration details associated with the target resource.
     */
    public suspend fun getServiceConfiguration(argument: GetServiceConfigurationPlainArgs): GetServiceConfigurationResult =
        getServiceConfigurationResultToKotlin(getServiceConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getServiceConfiguration].
     * @param endpointName The endpoint name.
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
     * @param serviceConfigurationName The service name.
     * @return The service configuration details associated with the target resource.
     */
    public suspend fun getServiceConfiguration(
        endpointName: String,
        resourceUri: String,
        serviceConfigurationName: String,
    ): GetServiceConfigurationResult {
        val argument = GetServiceConfigurationPlainArgs(
            endpointName = endpointName,
            resourceUri = resourceUri,
            serviceConfigurationName = serviceConfigurationName,
        )
        return getServiceConfigurationResultToKotlin(getServiceConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridconnectivity&#46;kotlin&#46;inputs&#46;GetServiceConfigurationPlainArgs].
     * @return The service configuration details associated with the target resource.
     */
    public suspend fun getServiceConfiguration(argument: suspend GetServiceConfigurationPlainArgsBuilder.() -> Unit): GetServiceConfigurationResult {
        val builder = GetServiceConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceConfigurationResultToKotlin(getServiceConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the endpoint access credentials to the resource.
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2022-05-01-preview.
     * @param argument null
     * @return The endpoint access for the target resource.
     */
    public suspend fun listEndpointCredentials(argument: ListEndpointCredentialsPlainArgs): ListEndpointCredentialsResult =
        listEndpointCredentialsResultToKotlin(listEndpointCredentialsPlain(argument.toJava()).await())

    /**
     * @see [listEndpointCredentials].
     * @param endpointName The endpoint name.
     * @param expiresin The is how long the endpoint access token is valid (in seconds).
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
     * @param serviceName The name of the service. If not provided, the request will by pass the generation of service configuration token
     * @return The endpoint access for the target resource.
     */
    public suspend fun listEndpointCredentials(
        endpointName: String,
        expiresin: Int? = null,
        resourceUri: String,
        serviceName: Either<String, ServiceName>? = null,
    ): ListEndpointCredentialsResult {
        val argument = ListEndpointCredentialsPlainArgs(
            endpointName = endpointName,
            expiresin = expiresin,
            resourceUri = resourceUri,
            serviceName = serviceName,
        )
        return listEndpointCredentialsResultToKotlin(listEndpointCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [listEndpointCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridconnectivity&#46;kotlin&#46;inputs&#46;ListEndpointCredentialsPlainArgs].
     * @return The endpoint access for the target resource.
     */
    public suspend fun listEndpointCredentials(argument: suspend ListEndpointCredentialsPlainArgsBuilder.() -> Unit): ListEndpointCredentialsResult {
        val builder = ListEndpointCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listEndpointCredentialsResultToKotlin(listEndpointCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the ingress gateway endpoint credentials
     * Azure REST API version: 2023-03-15.
     * @param argument null
     * @return The ingress gateway access credentials
     */
    public suspend fun listEndpointIngressGatewayCredentials(argument: ListEndpointIngressGatewayCredentialsPlainArgs): ListEndpointIngressGatewayCredentialsResult =
        listEndpointIngressGatewayCredentialsResultToKotlin(listEndpointIngressGatewayCredentialsPlain(argument.toJava()).await())

    /**
     * @see [listEndpointIngressGatewayCredentials].
     * @param endpointName The endpoint name.
     * @param expiresin The is how long the endpoint access token is valid (in seconds).
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
     * @param serviceName The name of the service.
     * @return The ingress gateway access credentials
     */
    public suspend fun listEndpointIngressGatewayCredentials(
        endpointName: String,
        expiresin: Int? = null,
        resourceUri: String,
        serviceName: Either<String, ServiceName>? = null,
    ): ListEndpointIngressGatewayCredentialsResult {
        val argument = ListEndpointIngressGatewayCredentialsPlainArgs(
            endpointName = endpointName,
            expiresin = expiresin,
            resourceUri = resourceUri,
            serviceName = serviceName,
        )
        return listEndpointIngressGatewayCredentialsResultToKotlin(listEndpointIngressGatewayCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [listEndpointIngressGatewayCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridconnectivity&#46;kotlin&#46;inputs&#46;ListEndpointIngressGatewayCredentialsPlainArgs].
     * @return The ingress gateway access credentials
     */
    public suspend fun listEndpointIngressGatewayCredentials(argument: suspend ListEndpointIngressGatewayCredentialsPlainArgsBuilder.() -> Unit): ListEndpointIngressGatewayCredentialsResult {
        val builder = ListEndpointIngressGatewayCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listEndpointIngressGatewayCredentialsResultToKotlin(listEndpointIngressGatewayCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * Fetches the managed proxy details
     * Azure REST API version: 2023-03-15.
     * Other available API versions: 2022-05-01-preview.
     * @param argument null
     * @return Managed Proxy
     */
    public suspend fun listEndpointManagedProxyDetails(argument: ListEndpointManagedProxyDetailsPlainArgs): ListEndpointManagedProxyDetailsResult =
        listEndpointManagedProxyDetailsResultToKotlin(listEndpointManagedProxyDetailsPlain(argument.toJava()).await())

    /**
     * @see [listEndpointManagedProxyDetails].
     * @param endpointName The endpoint name.
     * @param hostname The target host name.
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
     * @param service The name of the service.
     * @param serviceName The name of the service. It is an optional property, if not provided, service configuration tokens issue code would be by passed.
     * @return Managed Proxy
     */
    public suspend fun listEndpointManagedProxyDetails(
        endpointName: String,
        hostname: String? = null,
        resourceUri: String,
        service: String,
        serviceName: Either<String, ServiceName>? = null,
    ): ListEndpointManagedProxyDetailsResult {
        val argument = ListEndpointManagedProxyDetailsPlainArgs(
            endpointName = endpointName,
            hostname = hostname,
            resourceUri = resourceUri,
            service = service,
            serviceName = serviceName,
        )
        return listEndpointManagedProxyDetailsResultToKotlin(listEndpointManagedProxyDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [listEndpointManagedProxyDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridconnectivity&#46;kotlin&#46;inputs&#46;ListEndpointManagedProxyDetailsPlainArgs].
     * @return Managed Proxy
     */
    public suspend fun listEndpointManagedProxyDetails(argument: suspend ListEndpointManagedProxyDetailsPlainArgsBuilder.() -> Unit): ListEndpointManagedProxyDetailsResult {
        val builder = ListEndpointManagedProxyDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listEndpointManagedProxyDetailsResultToKotlin(listEndpointManagedProxyDetailsPlain(builtArgument.toJava()).await())
    }
}
