@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin

import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceConfiguration].
 */
@PulumiTagMarker
public class ServiceConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceConfigurationArgs = ServiceConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceConfigurationArgsBuilder.() -> Unit) {
        val builder = ServiceConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.hybridconnectivity.ServiceConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceConfiguration(builtJavaResource)
    }
}

/**
 * The service configuration details associated with the target resource.
 * Azure REST API version: 2023-03-15.
 * ## Example Usage
 * ### ServiceConfigurationsPutSSH
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceConfiguration = new AzureNative.HybridConnectivity.ServiceConfiguration("serviceConfiguration", new()
 *     {
 *         EndpointName = "default",
 *         Port = 22,
 *         ResourceUri = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine/providers/Microsoft.HybridConnectivity/endpoints/default",
 *         ServiceConfigurationName = "SSH",
 *         ServiceName = AzureNative.HybridConnectivity.ServiceName.SSH,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridconnectivity/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridconnectivity.NewServiceConfiguration(ctx, "serviceConfiguration", &hybridconnectivity.ServiceConfigurationArgs{
 * 			EndpointName:             pulumi.String("default"),
 * 			Port:                     pulumi.Float64(22),
 * 			ResourceUri:              pulumi.String("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine/providers/Microsoft.HybridConnectivity/endpoints/default"),
 * 			ServiceConfigurationName: pulumi.String("SSH"),
 * 			ServiceName:              pulumi.String(hybridconnectivity.ServiceNameSSH),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridconnectivity.ServiceConfiguration;
 * import com.pulumi.azurenative.hybridconnectivity.ServiceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceConfiguration = new ServiceConfiguration("serviceConfiguration", ServiceConfigurationArgs.builder()
 *             .endpointName("default")
 *             .port(22)
 *             .resourceUri("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine/providers/Microsoft.HybridConnectivity/endpoints/default")
 *             .serviceConfigurationName("SSH")
 *             .serviceName("SSH")
 *             .build());
 *     }
 * }
 * ```
 * ### ServiceConfigurationsPutWAC
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceConfiguration = new AzureNative.HybridConnectivity.ServiceConfiguration("serviceConfiguration", new()
 *     {
 *         EndpointName = "default",
 *         Port = 6516,
 *         ResourceUri = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine/providers/Microsoft.HybridConnectivity/endpoints/default",
 *         ServiceConfigurationName = "WAC",
 *         ServiceName = AzureNative.HybridConnectivity.ServiceName.WAC,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridconnectivity/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridconnectivity.NewServiceConfiguration(ctx, "serviceConfiguration", &hybridconnectivity.ServiceConfigurationArgs{
 * 			EndpointName:             pulumi.String("default"),
 * 			Port:                     pulumi.Float64(6516),
 * 			ResourceUri:              pulumi.String("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine/providers/Microsoft.HybridConnectivity/endpoints/default"),
 * 			ServiceConfigurationName: pulumi.String("WAC"),
 * 			ServiceName:              pulumi.String(hybridconnectivity.ServiceNameWAC),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridconnectivity.ServiceConfiguration;
 * import com.pulumi.azurenative.hybridconnectivity.ServiceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceConfiguration = new ServiceConfiguration("serviceConfiguration", ServiceConfigurationArgs.builder()
 *             .endpointName("default")
 *             .port(6516)
 *             .resourceUri("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine/providers/Microsoft.HybridConnectivity/endpoints/default")
 *             .serviceConfigurationName("WAC")
 *             .serviceName("WAC")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridconnectivity:ServiceConfiguration myresource1 /{resourceUri}/providers/Microsoft.HybridConnectivity/endpoints/{endpointName}/serviceConfigurations/{serviceConfigurationName}
 * ```
 */
public class ServiceConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridconnectivity.ServiceConfiguration,
) : KotlinCustomResource(javaResource, ServiceConfigurationMapper) {
    /**
     * The timestamp of resource creation (UTC).
     */
    public val createdAt: Output<String>?
        get() = javaResource.createdAt().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The identity that created the resource.
     */
    public val createdBy: Output<String>?
        get() = javaResource.createdBy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of identity that created the resource.
     */
    public val createdByType: Output<String>?
        get() = javaResource.createdByType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The timestamp of resource last modification (UTC)
     */
    public val lastModifiedAt: Output<String>?
        get() = javaResource.lastModifiedAt().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identity that last modified the resource.
     */
    public val lastModifiedBy: Output<String>?
        get() = javaResource.lastModifiedBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of identity that last modified the resource.
     */
    public val lastModifiedByType: Output<String>?
        get() = javaResource.lastModifiedByType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The port on which service is enabled.
     */
    public val port: Output<Double>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource Id of the connectivity endpoint (optional).
     */
    public val resourceId: Output<String>?
        get() = javaResource.resourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the service.
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceConfigurationMapper : ResourceMapper<ServiceConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridconnectivity.ServiceConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): ServiceConfiguration = ServiceConfiguration(
        javaResource
            as com.pulumi.azurenative.hybridconnectivity.ServiceConfiguration,
    )
}

/**
 * @see [ServiceConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceConfiguration].
 */
public suspend fun serviceConfiguration(
    name: String,
    block: suspend ServiceConfigurationResourceBuilder.() -> Unit,
): ServiceConfiguration {
    val builder = ServiceConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceConfiguration(name: String): ServiceConfiguration {
    val builder = ServiceConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
