@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin

import com.pulumi.azurenative.hybridconnectivity.ServiceConfigurationArgs.builder
import com.pulumi.azurenative.hybridconnectivity.kotlin.enums.CreatedByType
import com.pulumi.azurenative.hybridconnectivity.kotlin.enums.ServiceName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The service configuration details associated with the target resource.
 * Azure REST API version: 2023-03-15.
 * ## Example Usage
 * ### ServiceConfigurationsPutSSH
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceConfiguration = new AzureNative.HybridConnectivity.ServiceConfiguration("serviceConfiguration", new()
 *     {
 *         EndpointName = "default",
 *         Port = 22,
 *         ResourceUri = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine/providers/Microsoft.HybridConnectivity/endpoints/default",
 *         ServiceConfigurationName = "SSH",
 *         ServiceName = AzureNative.HybridConnectivity.ServiceName.SSH,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridconnectivity/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridconnectivity.NewServiceConfiguration(ctx, "serviceConfiguration", &hybridconnectivity.ServiceConfigurationArgs{
 * 			EndpointName:             pulumi.String("default"),
 * 			Port:                     pulumi.Float64(22),
 * 			ResourceUri:              pulumi.String("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine/providers/Microsoft.HybridConnectivity/endpoints/default"),
 * 			ServiceConfigurationName: pulumi.String("SSH"),
 * 			ServiceName:              pulumi.String(hybridconnectivity.ServiceNameSSH),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridconnectivity.ServiceConfiguration;
 * import com.pulumi.azurenative.hybridconnectivity.ServiceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceConfiguration = new ServiceConfiguration("serviceConfiguration", ServiceConfigurationArgs.builder()
 *             .endpointName("default")
 *             .port(22)
 *             .resourceUri("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine/providers/Microsoft.HybridConnectivity/endpoints/default")
 *             .serviceConfigurationName("SSH")
 *             .serviceName("SSH")
 *             .build());
 *     }
 * }
 * ```
 * ### ServiceConfigurationsPutWAC
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceConfiguration = new AzureNative.HybridConnectivity.ServiceConfiguration("serviceConfiguration", new()
 *     {
 *         EndpointName = "default",
 *         Port = 6516,
 *         ResourceUri = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine/providers/Microsoft.HybridConnectivity/endpoints/default",
 *         ServiceConfigurationName = "WAC",
 *         ServiceName = AzureNative.HybridConnectivity.ServiceName.WAC,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridconnectivity/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridconnectivity.NewServiceConfiguration(ctx, "serviceConfiguration", &hybridconnectivity.ServiceConfigurationArgs{
 * 			EndpointName:             pulumi.String("default"),
 * 			Port:                     pulumi.Float64(6516),
 * 			ResourceUri:              pulumi.String("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine/providers/Microsoft.HybridConnectivity/endpoints/default"),
 * 			ServiceConfigurationName: pulumi.String("WAC"),
 * 			ServiceName:              pulumi.String(hybridconnectivity.ServiceNameWAC),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridconnectivity.ServiceConfiguration;
 * import com.pulumi.azurenative.hybridconnectivity.ServiceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceConfiguration = new ServiceConfiguration("serviceConfiguration", ServiceConfigurationArgs.builder()
 *             .endpointName("default")
 *             .port(6516)
 *             .resourceUri("subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine/providers/Microsoft.HybridConnectivity/endpoints/default")
 *             .serviceConfigurationName("WAC")
 *             .serviceName("WAC")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridconnectivity:ServiceConfiguration myresource1 /{resourceUri}/providers/Microsoft.HybridConnectivity/endpoints/{endpointName}/serviceConfigurations/{serviceConfigurationName}
 * ```
 * @property createdAt The timestamp of resource creation (UTC).
 * @property createdBy The identity that created the resource.
 * @property createdByType The type of identity that created the resource.
 * @property endpointName The endpoint name.
 * @property lastModifiedAt The timestamp of resource last modification (UTC)
 * @property lastModifiedBy The identity that last modified the resource.
 * @property lastModifiedByType The type of identity that last modified the resource.
 * @property port The port on which service is enabled.
 * @property resourceId The resource Id of the connectivity endpoint (optional).
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
 * @property serviceConfigurationName The service name.
 * @property serviceName Name of the service.
 */
public data class ServiceConfigurationArgs(
    public val createdAt: Output<String>? = null,
    public val createdBy: Output<String>? = null,
    public val createdByType: Output<Either<String, CreatedByType>>? = null,
    public val endpointName: Output<String>? = null,
    public val lastModifiedAt: Output<String>? = null,
    public val lastModifiedBy: Output<String>? = null,
    public val lastModifiedByType: Output<Either<String, CreatedByType>>? = null,
    public val port: Output<Double>? = null,
    public val resourceId: Output<String>? = null,
    public val resourceUri: Output<String>? = null,
    public val serviceConfigurationName: Output<String>? = null,
    public val serviceName: Output<Either<String, ServiceName>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridconnectivity.ServiceConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridconnectivity.ServiceConfigurationArgs =
        com.pulumi.azurenative.hybridconnectivity.ServiceConfigurationArgs.builder()
            .createdAt(createdAt?.applyValue({ args0 -> args0 }))
            .createdBy(createdBy?.applyValue({ args0 -> args0 }))
            .createdByType(
                createdByType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .lastModifiedAt(lastModifiedAt?.applyValue({ args0 -> args0 }))
            .lastModifiedBy(lastModifiedBy?.applyValue({ args0 -> args0 }))
            .lastModifiedByType(
                lastModifiedByType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 }))
            .serviceConfigurationName(serviceConfigurationName?.applyValue({ args0 -> args0 }))
            .serviceName(
                serviceName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServiceConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceConfigurationArgsBuilder internal constructor() {
    private var createdAt: Output<String>? = null

    private var createdBy: Output<String>? = null

    private var createdByType: Output<Either<String, CreatedByType>>? = null

    private var endpointName: Output<String>? = null

    private var lastModifiedAt: Output<String>? = null

    private var lastModifiedBy: Output<String>? = null

    private var lastModifiedByType: Output<Either<String, CreatedByType>>? = null

    private var port: Output<Double>? = null

    private var resourceId: Output<String>? = null

    private var resourceUri: Output<String>? = null

    private var serviceConfigurationName: Output<String>? = null

    private var serviceName: Output<Either<String, ServiceName>>? = null

    /**
     * @param value The timestamp of resource creation (UTC).
     */
    @JvmName("phjwcubxulgtjvxg")
    public suspend fun createdAt(`value`: Output<String>) {
        this.createdAt = value
    }

    /**
     * @param value The identity that created the resource.
     */
    @JvmName("mwkmiwhlngjecqgb")
    public suspend fun createdBy(`value`: Output<String>) {
        this.createdBy = value
    }

    /**
     * @param value The type of identity that created the resource.
     */
    @JvmName("ildgfmfnluuehqun")
    public suspend fun createdByType(`value`: Output<Either<String, CreatedByType>>) {
        this.createdByType = value
    }

    /**
     * @param value The endpoint name.
     */
    @JvmName("rwtbcantwxwldglf")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value The timestamp of resource last modification (UTC)
     */
    @JvmName("ttipptjuxtvnqlyt")
    public suspend fun lastModifiedAt(`value`: Output<String>) {
        this.lastModifiedAt = value
    }

    /**
     * @param value The identity that last modified the resource.
     */
    @JvmName("bdcuqvixupxnxgvk")
    public suspend fun lastModifiedBy(`value`: Output<String>) {
        this.lastModifiedBy = value
    }

    /**
     * @param value The type of identity that last modified the resource.
     */
    @JvmName("deludbfjgpoluhkl")
    public suspend fun lastModifiedByType(`value`: Output<Either<String, CreatedByType>>) {
        this.lastModifiedByType = value
    }

    /**
     * @param value The port on which service is enabled.
     */
    @JvmName("aluafkvvnxkqxbaq")
    public suspend fun port(`value`: Output<Double>) {
        this.port = value
    }

    /**
     * @param value The resource Id of the connectivity endpoint (optional).
     */
    @JvmName("idstbolydtlkdekm")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource to be connected.
     */
    @JvmName("silfbnbjjohjaijw")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value The service name.
     */
    @JvmName("etpacxxgvvbcgorj")
    public suspend fun serviceConfigurationName(`value`: Output<String>) {
        this.serviceConfigurationName = value
    }

    /**
     * @param value Name of the service.
     */
    @JvmName("peogprgxegpygvmr")
    public suspend fun serviceName(`value`: Output<Either<String, ServiceName>>) {
        this.serviceName = value
    }

    /**
     * @param value The timestamp of resource creation (UTC).
     */
    @JvmName("xtpapjntfyfofyga")
    public suspend fun createdAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdAt = mapped
    }

    /**
     * @param value The identity that created the resource.
     */
    @JvmName("jtxaqgmobptfhweg")
    public suspend fun createdBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdBy = mapped
    }

    /**
     * @param value The type of identity that created the resource.
     */
    @JvmName("tshyqmdiwpivlrpu")
    public suspend fun createdByType(`value`: Either<String, CreatedByType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdByType = mapped
    }

    /**
     * @param value The type of identity that created the resource.
     */
    @JvmName("bxstmucqokyfukra")
    public fun createdByType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreatedByType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createdByType = mapped
    }

    /**
     * @param value The type of identity that created the resource.
     */
    @JvmName("efbhwhimjtsaaask")
    public fun createdByType(`value`: CreatedByType) {
        val toBeMapped = Either.ofRight<String, CreatedByType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createdByType = mapped
    }

    /**
     * @param value The endpoint name.
     */
    @JvmName("ijxvfnupqlobqebd")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value The timestamp of resource last modification (UTC)
     */
    @JvmName("ortssqdleieyhdst")
    public suspend fun lastModifiedAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedAt = mapped
    }

    /**
     * @param value The identity that last modified the resource.
     */
    @JvmName("oqbauipeglvvncto")
    public suspend fun lastModifiedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedBy = mapped
    }

    /**
     * @param value The type of identity that last modified the resource.
     */
    @JvmName("hbywwimiqfehwtss")
    public suspend fun lastModifiedByType(`value`: Either<String, CreatedByType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedByType = mapped
    }

    /**
     * @param value The type of identity that last modified the resource.
     */
    @JvmName("emjxbuafwarvgjbw")
    public fun lastModifiedByType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreatedByType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lastModifiedByType = mapped
    }

    /**
     * @param value The type of identity that last modified the resource.
     */
    @JvmName("kbjrwyllrevraqco")
    public fun lastModifiedByType(`value`: CreatedByType) {
        val toBeMapped = Either.ofRight<String, CreatedByType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lastModifiedByType = mapped
    }

    /**
     * @param value The port on which service is enabled.
     */
    @JvmName("xxmlayierdjknuqc")
    public suspend fun port(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The resource Id of the connectivity endpoint (optional).
     */
    @JvmName("iitsljdtkthqqdgm")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource to be connected.
     */
    @JvmName("nrabiwessdkikivp")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    /**
     * @param value The service name.
     */
    @JvmName("rlfxxsmumescudla")
    public suspend fun serviceConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceConfigurationName = mapped
    }

    /**
     * @param value Name of the service.
     */
    @JvmName("kfqykgkllgcfnwko")
    public suspend fun serviceName(`value`: Either<String, ServiceName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Name of the service.
     */
    @JvmName("jfukogfkfrhghxte")
    public fun serviceName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Name of the service.
     */
    @JvmName("iuoindawauhybvas")
    public fun serviceName(`value`: ServiceName) {
        val toBeMapped = Either.ofRight<String, ServiceName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ServiceConfigurationArgs = ServiceConfigurationArgs(
        createdAt = createdAt,
        createdBy = createdBy,
        createdByType = createdByType,
        endpointName = endpointName,
        lastModifiedAt = lastModifiedAt,
        lastModifiedBy = lastModifiedBy,
        lastModifiedByType = lastModifiedByType,
        port = port,
        resourceId = resourceId,
        resourceUri = resourceUri,
        serviceConfigurationName = serviceConfigurationName,
        serviceName = serviceName,
    )
}
