@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin.inputs

import com.pulumi.azurenative.hybridconnectivity.inputs.GetServiceConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName The endpoint name.
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
 * @property serviceConfigurationName The service name.
 */
public data class GetServiceConfigurationPlainArgs(
    public val endpointName: String,
    public val resourceUri: String,
    public val serviceConfigurationName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridconnectivity.inputs.GetServiceConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridconnectivity.inputs.GetServiceConfigurationPlainArgs =
        com.pulumi.azurenative.hybridconnectivity.inputs.GetServiceConfigurationPlainArgs.builder()
            .endpointName(endpointName.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 }))
            .serviceConfigurationName(serviceConfigurationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetServiceConfigurationPlainArgsBuilder internal constructor() {
    private var endpointName: String? = null

    private var resourceUri: String? = null

    private var serviceConfigurationName: String? = null

    /**
     * @param value The endpoint name.
     */
    @JvmName("auxfdjgsqtxfjart")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource to be connected.
     */
    @JvmName("lecndigqaaqyaqgc")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    /**
     * @param value The service name.
     */
    @JvmName("ayprjtrtpqkltgnv")
    public suspend fun serviceConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceConfigurationName = mapped
    }

    internal fun build(): GetServiceConfigurationPlainArgs = GetServiceConfigurationPlainArgs(
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
        serviceConfigurationName = serviceConfigurationName ?: throw
            PulumiNullFieldException("serviceConfigurationName"),
    )
}
