@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Endpoint details
 * @property provisioningState The resource provisioning state.
 * @property resourceId The resource Id of the connectivity endpoint (optional).
 * @property type The type of endpoint.
 */
public data class EndpointPropertiesResponse(
    public val provisioningState: String,
    public val resourceId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridconnectivity.outputs.EndpointPropertiesResponse): EndpointPropertiesResponse = EndpointPropertiesResponse(
            provisioningState = javaType.provisioningState(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
