@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The service configuration details associated with the target resource.
 * @property createdAt The timestamp of resource creation (UTC).
 * @property createdBy The identity that created the resource.
 * @property createdByType The type of identity that created the resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property lastModifiedAt The timestamp of resource last modification (UTC)
 * @property lastModifiedBy The identity that last modified the resource.
 * @property lastModifiedByType The type of identity that last modified the resource.
 * @property name The name of the resource
 * @property port The port on which service is enabled.
 * @property provisioningState The resource provisioning state.
 * @property resourceId The resource Id of the connectivity endpoint (optional).
 * @property serviceName Name of the service.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetServiceConfigurationResult(
    public val createdAt: String? = null,
    public val createdBy: String? = null,
    public val createdByType: String? = null,
    public val id: String,
    public val lastModifiedAt: String? = null,
    public val lastModifiedBy: String? = null,
    public val lastModifiedByType: String? = null,
    public val name: String,
    public val port: Double? = null,
    public val provisioningState: String,
    public val resourceId: String? = null,
    public val serviceName: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridconnectivity.outputs.GetServiceConfigurationResult): GetServiceConfigurationResult = GetServiceConfigurationResult(
            createdAt = javaType.createdAt().map({ args0 -> args0 }).orElse(null),
            createdBy = javaType.createdBy().map({ args0 -> args0 }).orElse(null),
            createdByType = javaType.createdByType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModifiedAt = javaType.lastModifiedAt().map({ args0 -> args0 }).orElse(null),
            lastModifiedBy = javaType.lastModifiedBy().map({ args0 -> args0 }).orElse(null),
            lastModifiedByType = javaType.lastModifiedByType().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            serviceName = javaType.serviceName(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridconnectivity.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
