@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin

import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClusterIdentityResponse
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClusterIdentityResponse.Companion.toKotlin as provisionedClusterIdentityResponseToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [HybridIdentityMetadatum].
 */
@PulumiTagMarker
public class HybridIdentityMetadatumResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HybridIdentityMetadatumArgs = HybridIdentityMetadatumArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HybridIdentityMetadatumArgsBuilder.() -> Unit) {
        val builder = HybridIdentityMetadatumArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HybridIdentityMetadatum {
        val builtJavaResource =
            com.pulumi.azurenative.hybridcontainerservice.HybridIdentityMetadatum(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HybridIdentityMetadatum(builtJavaResource)
    }
}

/**
 * Defines the hybridIdentityMetadata.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * Other available API versions: 2022-05-01-preview, 2023-11-15-preview, 2024-01-01.
 * ## Example Usage
 * ### CreateHybridIdentityMetadata
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridIdentityMetadatum = new AzureNative.HybridContainerService.HybridIdentityMetadatum("hybridIdentityMetadatum", new()
 *     {
 *         HybridIdentityMetadataResourceName = "default",
 *         PublicKey = "8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2",
 *         ResourceGroupName = "testrg",
 *         ResourceName = "ContosoTargetCluster",
 *         ResourceUid = "f8b82dff-38ef-4220-99ef-d3a3f86ddc6c",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcontainerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcontainerservice.NewHybridIdentityMetadatum(ctx, "hybridIdentityMetadatum", &hybridcontainerservice.HybridIdentityMetadatumArgs{
 * 			HybridIdentityMetadataResourceName: pulumi.String("default"),
 * 			PublicKey:                          pulumi.String("8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2"),
 * 			ResourceGroupName:                  pulumi.String("testrg"),
 * 			ResourceName:                       pulumi.String("ContosoTargetCluster"),
 * 			ResourceUid:                        pulumi.String("f8b82dff-38ef-4220-99ef-d3a3f86ddc6c"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcontainerservice.HybridIdentityMetadatum;
 * import com.pulumi.azurenative.hybridcontainerservice.HybridIdentityMetadatumArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridIdentityMetadatum = new HybridIdentityMetadatum("hybridIdentityMetadatum", HybridIdentityMetadatumArgs.builder()
 *             .hybridIdentityMetadataResourceName("default")
 *             .publicKey("8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2")
 *             .resourceGroupName("testrg")
 *             .resourceName("ContosoTargetCluster")
 *             .resourceUid("f8b82dff-38ef-4220-99ef-d3a3f86ddc6c")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcontainerservice:HybridIdentityMetadatum default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/provisionedClusters/{resourceName}/hybridIdentityMetadata/{hybridIdentityMetadataResourceName}
 * ```
 */
public class HybridIdentityMetadatum internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridcontainerservice.HybridIdentityMetadatum,
) : KotlinCustomResource(javaResource, HybridIdentityMetadatumMapper) {
    /**
     * The identity of the provisioned cluster.
     */
    public val identity: Output<ProvisionedClusterIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    provisionedClusterIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * provisioning state of the hybridIdentityMetadata resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Onboarding public key for provisioning the Managed identity for the HybridAKS cluster.
     */
    public val publicKey: Output<String>?
        get() = javaResource.publicKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Unique id of the parent provisioned cluster resource.
     */
    public val resourceUid: Output<String>?
        get() = javaResource.resourceUid().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system data.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HybridIdentityMetadatumMapper : ResourceMapper<HybridIdentityMetadatum> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridcontainerservice.HybridIdentityMetadatum::class == javaResource::class

    override fun map(javaResource: Resource): HybridIdentityMetadatum =
        HybridIdentityMetadatum(
            javaResource as
                com.pulumi.azurenative.hybridcontainerservice.HybridIdentityMetadatum,
        )
}

/**
 * @see [HybridIdentityMetadatum].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HybridIdentityMetadatum].
 */
public suspend fun hybridIdentityMetadatum(
    name: String,
    block: suspend HybridIdentityMetadatumResourceBuilder.() -> Unit,
): HybridIdentityMetadatum {
    val builder = HybridIdentityMetadatumResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HybridIdentityMetadatum].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hybridIdentityMetadatum(name: String): HybridIdentityMetadatum {
    val builder = HybridIdentityMetadatumResourceBuilder()
    builder.name(name)
    return builder.build()
}
