@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin

import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClusterIdentityResponse
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClustersResponsePropertiesResponse
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClustersResponseResponseExtendedLocation
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClusterIdentityResponse.Companion.toKotlin as provisionedClusterIdentityResponseToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClustersResponsePropertiesResponse.Companion.toKotlin as provisionedClustersResponsePropertiesResponseToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClustersResponseResponseExtendedLocation.Companion.toKotlin as provisionedClustersResponseResponseExtendedLocationToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ProvisionedCluster].
 */
@PulumiTagMarker
public class ProvisionedClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProvisionedClusterArgs = ProvisionedClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProvisionedClusterArgsBuilder.() -> Unit) {
        val builder = ProvisionedClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProvisionedCluster {
        val builtJavaResource =
            com.pulumi.azurenative.hybridcontainerservice.ProvisionedCluster(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProvisionedCluster(builtJavaResource)
    }
}

/**
 * The provisionedClusters resource definition.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * Other available API versions: 2022-05-01-preview.
 * ## Example Usage
 * ### PutProvisionedCluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var provisionedCluster = new AzureNative.HybridContainerService.ProvisionedCluster("provisionedCluster", new()
 *     {
 *         ExtendedLocation = new AzureNative.HybridContainerService.Inputs.ProvisionedClustersExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation",
 *             Type = "CustomLocation",
 *         },
 *         Location = "westus",
 *         Properties = new AzureNative.HybridContainerService.Inputs.ProvisionedClustersAllPropertiesArgs
 *         {
 *             AgentPoolProfiles = new[]
 *             {
 *                 new AzureNative.HybridContainerService.Inputs.NamedAgentPoolProfileArgs
 *                 {
 *                     Count = 1,
 *                     Name = "default-nodepool-1",
 *                     OsType = AzureNative.HybridContainerService.OsType.Linux,
 *                     VmSize = "Standard_A4_v2",
 *                 },
 *             },
 *             CloudProviderProfile = new AzureNative.HybridContainerService.Inputs.CloudProviderProfileArgs
 *             {
 *                 InfraNetworkProfile = new AzureNative.HybridContainerService.Inputs.CloudProviderProfileInfraNetworkProfileArgs
 *                 {
 *                     VnetSubnetIds = new[]
 *                     {
 *                         "/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/virtualNetworks/test-vnet-static",
 *                     },
 *                 },
 *                 InfraStorageProfile = new AzureNative.HybridContainerService.Inputs.CloudProviderProfileInfraStorageProfileArgs
 *                 {
 *                     StorageSpaceIds = new[]
 *                     {
 *                         "/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/storageSpaces/test-storage",
 *                     },
 *                 },
 *             },
 *             ControlPlane = new AzureNative.HybridContainerService.Inputs.ControlPlaneProfileArgs
 *             {
 *                 Count = 1,
 *                 LinuxProfile = new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesArgs
 *                 {
 *                     Ssh = new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesSshArgs
 *                     {
 *                         PublicKeys = new[]
 *                         {
 *                             new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesPublicKeysArgs
 *                             {
 *                                 KeyData = "ssh-rsa AAAAB1NzaC1yc2EAAAADAQABAAACAQCY......",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 OsType = AzureNative.HybridContainerService.OsType.Linux,
 *                 VmSize = "Standard_A4_v2",
 *             },
 *             KubernetesVersion = "v1.20.5",
 *             LinuxProfile = new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesArgs
 *             {
 *                 Ssh = new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesSshArgs
 *                 {
 *                     PublicKeys = new[]
 *                     {
 *                         new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesPublicKeysArgs
 *                         {
 *                             KeyData = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCY.......",
 *                         },
 *                     },
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.HybridContainerService.Inputs.NetworkProfileArgs
 *             {
 *                 LoadBalancerProfile = new AzureNative.HybridContainerService.Inputs.LoadBalancerProfileArgs
 *                 {
 *                     Count = 1,
 *                     LinuxProfile = new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesArgs
 *                     {
 *                         Ssh = new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesSshArgs
 *                         {
 *                             PublicKeys = new[]
 *                             {
 *                                 new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesPublicKeysArgs
 *                                 {
 *                                     KeyData = "ssh-rsa AAAAB2NzaC1yc2EAAAADAQABAAACAQCY......",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     OsType = AzureNative.HybridContainerService.OsType.Linux,
 *                     VmSize = "Standard_K8S3_v1",
 *                 },
 *                 LoadBalancerSku = AzureNative.HybridContainerService.LoadBalancerSku.Unstacked_haproxy,
 *                 NetworkPolicy = AzureNative.HybridContainerService.NetworkPolicy.Calico,
 *                 PodCidr = "10.244.0.0/16",
 *             },
 *         },
 *         ResourceGroupName = "test-arcappliance-resgrp",
 *         ResourceName = "test-hybridakscluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcontainerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcontainerservice.NewProvisionedCluster(ctx, "provisionedCluster", &hybridcontainerservice.ProvisionedClusterArgs{
 * 			ExtendedLocation: &hybridcontainerservice.ProvisionedClustersExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Properties: &hybridcontainerservice.ProvisionedClustersAllPropertiesArgs{
 * 				AgentPoolProfiles: hybridcontainerservice.NamedAgentPoolProfileArray{
 * 					&hybridcontainerservice.NamedAgentPoolProfileArgs{
 * 						Count:  pulumi.Int(1),
 * 						Name:   pulumi.String("default-nodepool-1"),
 * 						OsType: pulumi.String(hybridcontainerservice.OsTypeLinux),
 * 						VmSize: pulumi.String("Standard_A4_v2"),
 * 					},
 * 				},
 * 				CloudProviderProfile: &hybridcontainerservice.CloudProviderProfileArgs{
 * 					InfraNetworkProfile: &hybridcontainerservice.CloudProviderProfileInfraNetworkProfileArgs{
 * 						VnetSubnetIds: pulumi.StringArray{
 * 							pulumi.String("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/virtualNetworks/test-vnet-static"),
 * 						},
 * 					},
 * 					InfraStorageProfile: &hybridcontainerservice.CloudProviderProfileInfraStorageProfileArgs{
 * 						StorageSpaceIds: pulumi.StringArray{
 * 							pulumi.String("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/storageSpaces/test-storage"),
 * 						},
 * 					},
 * 				},
 * 				ControlPlane: &hybridcontainerservice.ControlPlaneProfileArgs{
 * 					Count: pulumi.Int(1),
 * 					LinuxProfile: &hybridcontainerservice.LinuxProfilePropertiesArgs{
 * 						Ssh: &hybridcontainerservice.LinuxProfilePropertiesSshArgs{
 * 							PublicKeys: hybridcontainerservice.LinuxProfilePropertiesPublicKeysArray{
 * 								&hybridcontainerservice.LinuxProfilePropertiesPublicKeysArgs{
 * 									KeyData: pulumi.String("ssh-rsa AAAAB1NzaC1yc2EAAAADAQABAAACAQCY......"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 					OsType: pulumi.String(hybridcontainerservice.OsTypeLinux),
 * 					VmSize: pulumi.String("Standard_A4_v2"),
 * 				},
 * 				KubernetesVersion: pulumi.String("v1.20.5"),
 * 				LinuxProfile: &hybridcontainerservice.LinuxProfilePropertiesArgs{
 * 					Ssh: &hybridcontainerservice.LinuxProfilePropertiesSshArgs{
 * 						PublicKeys: hybridcontainerservice.LinuxProfilePropertiesPublicKeysArray{
 * 							&hybridcontainerservice.LinuxProfilePropertiesPublicKeysArgs{
 * 								KeyData: pulumi.String("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCY......."),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				NetworkProfile: &hybridcontainerservice.NetworkProfileArgs{
 * 					LoadBalancerProfile: &hybridcontainerservice.LoadBalancerProfileArgs{
 * 						Count: pulumi.Int(1),
 * 						LinuxProfile: &hybridcontainerservice.LinuxProfilePropertiesArgs{
 * 							Ssh: &hybridcontainerservice.LinuxProfilePropertiesSshArgs{
 * 								PublicKeys: hybridcontainerservice.LinuxProfilePropertiesPublicKeysArray{
 * 									&hybridcontainerservice.LinuxProfilePropertiesPublicKeysArgs{
 * 										KeyData: pulumi.String("ssh-rsa AAAAB2NzaC1yc2EAAAADAQABAAACAQCY......"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						OsType: pulumi.String(hybridcontainerservice.OsTypeLinux),
 * 						VmSize: pulumi.String("Standard_K8S3_v1"),
 * 					},
 * 					LoadBalancerSku: pulumi.String(hybridcontainerservice.LoadBalancerSku_Unstacked_Haproxy),
 * 					NetworkPolicy:   pulumi.String(hybridcontainerservice.NetworkPolicyCalico),
 * 					PodCidr:         pulumi.String("10.244.0.0/16"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("test-arcappliance-resgrp"),
 * 			ResourceName:      pulumi.String("test-hybridakscluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcontainerservice.ProvisionedCluster;
 * import com.pulumi.azurenative.hybridcontainerservice.ProvisionedClusterArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersExtendedLocationArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersAllPropertiesArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileInfraNetworkProfileArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileInfraStorageProfileArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.ControlPlaneProfileArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesSshArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.LoadBalancerProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var provisionedCluster = new ProvisionedCluster("provisionedCluster", ProvisionedClusterArgs.builder()
 *             .extendedLocation(ProvisionedClustersExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("westus")
 *             .properties(ProvisionedClustersAllPropertiesArgs.builder()
 *                 .agentPoolProfiles(NamedAgentPoolProfileArgs.builder()
 *                     .count(1)
 *                     .name("default-nodepool-1")
 *                     .osType("Linux")
 *                     .vmSize("Standard_A4_v2")
 *                     .build())
 *                 .cloudProviderProfile(CloudProviderProfileArgs.builder()
 *                     .infraNetworkProfile(CloudProviderProfileInfraNetworkProfileArgs.builder()
 *                         .vnetSubnetIds("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/virtualNetworks/test-vnet-static")
 *                         .build())
 *                     .infraStorageProfile(CloudProviderProfileInfraStorageProfileArgs.builder()
 *                         .storageSpaceIds("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/storageSpaces/test-storage")
 *                         .build())
 *                     .build())
 *                 .controlPlane(ControlPlaneProfileArgs.builder()
 *                     .count(1)
 *                     .linuxProfile(LinuxProfilePropertiesArgs.builder()
 *                         .ssh(LinuxProfilePropertiesSshArgs.builder()
 *                             .publicKeys(LinuxProfilePropertiesPublicKeysArgs.builder()
 *                                 .keyData("ssh-rsa AAAAB1NzaC1yc2EAAAADAQABAAACAQCY......")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .osType("Linux")
 *                     .vmSize("Standard_A4_v2")
 *                     .build())
 *                 .kubernetesVersion("v1.20.5")
 *                 .linuxProfile(LinuxProfilePropertiesArgs.builder()
 *                     .ssh(LinuxProfilePropertiesSshArgs.builder()
 *                         .publicKeys(LinuxProfilePropertiesPublicKeysArgs.builder()
 *                             .keyData("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCY.......")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .networkProfile(NetworkProfileArgs.builder()
 *                     .loadBalancerProfile(LoadBalancerProfileArgs.builder()
 *                         .count(1)
 *                         .linuxProfile(LinuxProfilePropertiesArgs.builder()
 *                             .ssh(LinuxProfilePropertiesSshArgs.builder()
 *                                 .publicKeys(LinuxProfilePropertiesPublicKeysArgs.builder()
 *                                     .keyData("ssh-rsa AAAAB2NzaC1yc2EAAAADAQABAAACAQCY......")
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .osType("Linux")
 *                         .vmSize("Standard_K8S3_v1")
 *                         .build())
 *                     .loadBalancerSku("unstacked-haproxy")
 *                     .networkPolicy("calico")
 *                     .podCidr("10.244.0.0/16")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("test-arcappliance-resgrp")
 *             .resourceName("test-hybridakscluster")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcontainerservice:ProvisionedCluster test-hybridakscluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/provisionedClusters/{resourceName}
 * ```
 */
public class ProvisionedCluster internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridcontainerservice.ProvisionedCluster,
) : KotlinCustomResource(javaResource, ProvisionedClusterMapper) {
    public val extendedLocation: Output<ProvisionedClustersResponseResponseExtendedLocation>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    provisionedClustersResponseResponseExtendedLocationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Identity for the Provisioned cluster.
     */
    public val identity: Output<ProvisionedClusterIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    provisionedClusterIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<ProvisionedClustersResponsePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                provisionedClustersResponsePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProvisionedClusterMapper : ResourceMapper<ProvisionedCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridcontainerservice.ProvisionedCluster::class == javaResource::class

    override fun map(javaResource: Resource): ProvisionedCluster = ProvisionedCluster(
        javaResource as
            com.pulumi.azurenative.hybridcontainerservice.ProvisionedCluster,
    )
}

/**
 * @see [ProvisionedCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProvisionedCluster].
 */
public suspend fun provisionedCluster(
    name: String,
    block: suspend ProvisionedClusterResourceBuilder.() -> Unit,
): ProvisionedCluster {
    val builder = ProvisionedClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProvisionedCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun provisionedCluster(name: String): ProvisionedCluster {
    val builder = ProvisionedClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
