@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin

import com.pulumi.azurenative.hybridcontainerservice.ProvisionedClusterArgs.builder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.ProvisionedClusterIdentityArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.ProvisionedClusterIdentityArgsBuilder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.ProvisionedClustersAllPropertiesArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.ProvisionedClustersAllPropertiesArgsBuilder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.ProvisionedClustersExtendedLocationArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.ProvisionedClustersExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The provisionedClusters resource definition.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * Other available API versions: 2022-05-01-preview.
 * ## Example Usage
 * ### PutProvisionedCluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var provisionedCluster = new AzureNative.HybridContainerService.ProvisionedCluster("provisionedCluster", new()
 *     {
 *         ExtendedLocation = new AzureNative.HybridContainerService.Inputs.ProvisionedClustersExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation",
 *             Type = "CustomLocation",
 *         },
 *         Location = "westus",
 *         Properties = new AzureNative.HybridContainerService.Inputs.ProvisionedClustersAllPropertiesArgs
 *         {
 *             AgentPoolProfiles = new[]
 *             {
 *                 new AzureNative.HybridContainerService.Inputs.NamedAgentPoolProfileArgs
 *                 {
 *                     Count = 1,
 *                     Name = "default-nodepool-1",
 *                     OsType = AzureNative.HybridContainerService.OsType.Linux,
 *                     VmSize = "Standard_A4_v2",
 *                 },
 *             },
 *             CloudProviderProfile = new AzureNative.HybridContainerService.Inputs.CloudProviderProfileArgs
 *             {
 *                 InfraNetworkProfile = new AzureNative.HybridContainerService.Inputs.CloudProviderProfileInfraNetworkProfileArgs
 *                 {
 *                     VnetSubnetIds = new[]
 *                     {
 *                         "/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/virtualNetworks/test-vnet-static",
 *                     },
 *                 },
 *                 InfraStorageProfile = new AzureNative.HybridContainerService.Inputs.CloudProviderProfileInfraStorageProfileArgs
 *                 {
 *                     StorageSpaceIds = new[]
 *                     {
 *                         "/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/storageSpaces/test-storage",
 *                     },
 *                 },
 *             },
 *             ControlPlane = new AzureNative.HybridContainerService.Inputs.ControlPlaneProfileArgs
 *             {
 *                 Count = 1,
 *                 LinuxProfile = new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesArgs
 *                 {
 *                     Ssh = new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesSshArgs
 *                     {
 *                         PublicKeys = new[]
 *                         {
 *                             new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesPublicKeysArgs
 *                             {
 *                                 KeyData = "ssh-rsa AAAAB1NzaC1yc2EAAAADAQABAAACAQCY......",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 OsType = AzureNative.HybridContainerService.OsType.Linux,
 *                 VmSize = "Standard_A4_v2",
 *             },
 *             KubernetesVersion = "v1.20.5",
 *             LinuxProfile = new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesArgs
 *             {
 *                 Ssh = new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesSshArgs
 *                 {
 *                     PublicKeys = new[]
 *                     {
 *                         new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesPublicKeysArgs
 *                         {
 *                             KeyData = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCY.......",
 *                         },
 *                     },
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.HybridContainerService.Inputs.NetworkProfileArgs
 *             {
 *                 LoadBalancerProfile = new AzureNative.HybridContainerService.Inputs.LoadBalancerProfileArgs
 *                 {
 *                     Count = 1,
 *                     LinuxProfile = new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesArgs
 *                     {
 *                         Ssh = new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesSshArgs
 *                         {
 *                             PublicKeys = new[]
 *                             {
 *                                 new AzureNative.HybridContainerService.Inputs.LinuxProfilePropertiesPublicKeysArgs
 *                                 {
 *                                     KeyData = "ssh-rsa AAAAB2NzaC1yc2EAAAADAQABAAACAQCY......",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     OsType = AzureNative.HybridContainerService.OsType.Linux,
 *                     VmSize = "Standard_K8S3_v1",
 *                 },
 *                 LoadBalancerSku = AzureNative.HybridContainerService.LoadBalancerSku.Unstacked_haproxy,
 *                 NetworkPolicy = AzureNative.HybridContainerService.NetworkPolicy.Calico,
 *                 PodCidr = "10.244.0.0/16",
 *             },
 *         },
 *         ResourceGroupName = "test-arcappliance-resgrp",
 *         ResourceName = "test-hybridakscluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcontainerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcontainerservice.NewProvisionedCluster(ctx, "provisionedCluster", &hybridcontainerservice.ProvisionedClusterArgs{
 * 			ExtendedLocation: &hybridcontainerservice.ProvisionedClustersExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Properties: &hybridcontainerservice.ProvisionedClustersAllPropertiesArgs{
 * 				AgentPoolProfiles: hybridcontainerservice.NamedAgentPoolProfileArray{
 * 					&hybridcontainerservice.NamedAgentPoolProfileArgs{
 * 						Count:  pulumi.Int(1),
 * 						Name:   pulumi.String("default-nodepool-1"),
 * 						OsType: pulumi.String(hybridcontainerservice.OsTypeLinux),
 * 						VmSize: pulumi.String("Standard_A4_v2"),
 * 					},
 * 				},
 * 				CloudProviderProfile: &hybridcontainerservice.CloudProviderProfileArgs{
 * 					InfraNetworkProfile: &hybridcontainerservice.CloudProviderProfileInfraNetworkProfileArgs{
 * 						VnetSubnetIds: pulumi.StringArray{
 * 							pulumi.String("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/virtualNetworks/test-vnet-static"),
 * 						},
 * 					},
 * 					InfraStorageProfile: &hybridcontainerservice.CloudProviderProfileInfraStorageProfileArgs{
 * 						StorageSpaceIds: pulumi.StringArray{
 * 							pulumi.String("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/storageSpaces/test-storage"),
 * 						},
 * 					},
 * 				},
 * 				ControlPlane: &hybridcontainerservice.ControlPlaneProfileArgs{
 * 					Count: pulumi.Int(1),
 * 					LinuxProfile: &hybridcontainerservice.LinuxProfilePropertiesArgs{
 * 						Ssh: &hybridcontainerservice.LinuxProfilePropertiesSshArgs{
 * 							PublicKeys: hybridcontainerservice.LinuxProfilePropertiesPublicKeysArray{
 * 								&hybridcontainerservice.LinuxProfilePropertiesPublicKeysArgs{
 * 									KeyData: pulumi.String("ssh-rsa AAAAB1NzaC1yc2EAAAADAQABAAACAQCY......"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 					OsType: pulumi.String(hybridcontainerservice.OsTypeLinux),
 * 					VmSize: pulumi.String("Standard_A4_v2"),
 * 				},
 * 				KubernetesVersion: pulumi.String("v1.20.5"),
 * 				LinuxProfile: &hybridcontainerservice.LinuxProfilePropertiesArgs{
 * 					Ssh: &hybridcontainerservice.LinuxProfilePropertiesSshArgs{
 * 						PublicKeys: hybridcontainerservice.LinuxProfilePropertiesPublicKeysArray{
 * 							&hybridcontainerservice.LinuxProfilePropertiesPublicKeysArgs{
 * 								KeyData: pulumi.String("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCY......."),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				NetworkProfile: &hybridcontainerservice.NetworkProfileArgs{
 * 					LoadBalancerProfile: &hybridcontainerservice.LoadBalancerProfileArgs{
 * 						Count: pulumi.Int(1),
 * 						LinuxProfile: &hybridcontainerservice.LinuxProfilePropertiesArgs{
 * 							Ssh: &hybridcontainerservice.LinuxProfilePropertiesSshArgs{
 * 								PublicKeys: hybridcontainerservice.LinuxProfilePropertiesPublicKeysArray{
 * 									&hybridcontainerservice.LinuxProfilePropertiesPublicKeysArgs{
 * 										KeyData: pulumi.String("ssh-rsa AAAAB2NzaC1yc2EAAAADAQABAAACAQCY......"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						OsType: pulumi.String(hybridcontainerservice.OsTypeLinux),
 * 						VmSize: pulumi.String("Standard_K8S3_v1"),
 * 					},
 * 					LoadBalancerSku: pulumi.String(hybridcontainerservice.LoadBalancerSku_Unstacked_Haproxy),
 * 					NetworkPolicy:   pulumi.String(hybridcontainerservice.NetworkPolicyCalico),
 * 					PodCidr:         pulumi.String("10.244.0.0/16"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("test-arcappliance-resgrp"),
 * 			ResourceName:      pulumi.String("test-hybridakscluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcontainerservice.ProvisionedCluster;
 * import com.pulumi.azurenative.hybridcontainerservice.ProvisionedClusterArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersExtendedLocationArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersAllPropertiesArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileInfraNetworkProfileArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileInfraStorageProfileArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.ControlPlaneProfileArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesSshArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.LoadBalancerProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var provisionedCluster = new ProvisionedCluster("provisionedCluster", ProvisionedClusterArgs.builder()
 *             .extendedLocation(ProvisionedClustersExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("westus")
 *             .properties(ProvisionedClustersAllPropertiesArgs.builder()
 *                 .agentPoolProfiles(NamedAgentPoolProfileArgs.builder()
 *                     .count(1)
 *                     .name("default-nodepool-1")
 *                     .osType("Linux")
 *                     .vmSize("Standard_A4_v2")
 *                     .build())
 *                 .cloudProviderProfile(CloudProviderProfileArgs.builder()
 *                     .infraNetworkProfile(CloudProviderProfileInfraNetworkProfileArgs.builder()
 *                         .vnetSubnetIds("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/virtualNetworks/test-vnet-static")
 *                         .build())
 *                     .infraStorageProfile(CloudProviderProfileInfraStorageProfileArgs.builder()
 *                         .storageSpaceIds("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/storageSpaces/test-storage")
 *                         .build())
 *                     .build())
 *                 .controlPlane(ControlPlaneProfileArgs.builder()
 *                     .count(1)
 *                     .linuxProfile(LinuxProfilePropertiesArgs.builder()
 *                         .ssh(LinuxProfilePropertiesSshArgs.builder()
 *                             .publicKeys(LinuxProfilePropertiesPublicKeysArgs.builder()
 *                                 .keyData("ssh-rsa AAAAB1NzaC1yc2EAAAADAQABAAACAQCY......")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .osType("Linux")
 *                     .vmSize("Standard_A4_v2")
 *                     .build())
 *                 .kubernetesVersion("v1.20.5")
 *                 .linuxProfile(LinuxProfilePropertiesArgs.builder()
 *                     .ssh(LinuxProfilePropertiesSshArgs.builder()
 *                         .publicKeys(LinuxProfilePropertiesPublicKeysArgs.builder()
 *                             .keyData("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCY.......")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .networkProfile(NetworkProfileArgs.builder()
 *                     .loadBalancerProfile(LoadBalancerProfileArgs.builder()
 *                         .count(1)
 *                         .linuxProfile(LinuxProfilePropertiesArgs.builder()
 *                             .ssh(LinuxProfilePropertiesSshArgs.builder()
 *                                 .publicKeys(LinuxProfilePropertiesPublicKeysArgs.builder()
 *                                     .keyData("ssh-rsa AAAAB2NzaC1yc2EAAAADAQABAAACAQCY......")
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .osType("Linux")
 *                         .vmSize("Standard_K8S3_v1")
 *                         .build())
 *                     .loadBalancerSku("unstacked-haproxy")
 *                     .networkPolicy("calico")
 *                     .podCidr("10.244.0.0/16")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("test-arcappliance-resgrp")
 *             .resourceName("test-hybridakscluster")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcontainerservice:ProvisionedCluster test-hybridakscluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/provisionedClusters/{resourceName}
 * ```
 * @property extendedLocation
 * @property identity Identity for the Provisioned cluster.
 * @property location The geo-location where the resource lives
 * @property properties All properties of the provisioned cluster
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName Parameter for the name of the provisioned cluster
 * @property tags Resource tags.
 */
public data class ProvisionedClusterArgs(
    public val extendedLocation: Output<ProvisionedClustersExtendedLocationArgs>? = null,
    public val identity: Output<ProvisionedClusterIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ProvisionedClustersAllPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.ProvisionedClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.ProvisionedClusterArgs =
        com.pulumi.azurenative.hybridcontainerservice.ProvisionedClusterArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProvisionedClusterArgs].
 */
@PulumiTagMarker
public class ProvisionedClusterArgsBuilder internal constructor() {
    private var extendedLocation: Output<ProvisionedClustersExtendedLocationArgs>? = null

    private var identity: Output<ProvisionedClusterIdentityArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<ProvisionedClustersAllPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("ablygshfwghmrgeo")
    public suspend fun extendedLocation(`value`: Output<ProvisionedClustersExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Identity for the Provisioned cluster.
     */
    @JvmName("qrciqqgjrrqltmys")
    public suspend fun identity(`value`: Output<ProvisionedClusterIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lrruwqxpqtftaqkf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value All properties of the provisioned cluster
     */
    @JvmName("kuuchndwtqniwqlb")
    public suspend fun properties(`value`: Output<ProvisionedClustersAllPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("exghjovdfwaqfsbs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Parameter for the name of the provisioned cluster
     */
    @JvmName("aokhmjiluioavxrq")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dqmchbnfcbonhyhl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("ipaijltbthxuryjk")
    public suspend fun extendedLocation(`value`: ProvisionedClustersExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nytylpyaqvvitehd")
    public suspend fun extendedLocation(argument: suspend ProvisionedClustersExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ProvisionedClustersExtendedLocationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Identity for the Provisioned cluster.
     */
    @JvmName("knjrofrsyckyoiwx")
    public suspend fun identity(`value`: ProvisionedClusterIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the Provisioned cluster.
     */
    @JvmName("gkmjoxvvhbhhldjp")
    public suspend fun identity(argument: suspend ProvisionedClusterIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ProvisionedClusterIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rbmpaweljsbrbdlj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value All properties of the provisioned cluster
     */
    @JvmName("yyrblnskkbkimohq")
    public suspend fun properties(`value`: ProvisionedClustersAllPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument All properties of the provisioned cluster
     */
    @JvmName("ggipbkqqunxbguxl")
    public suspend fun properties(argument: suspend ProvisionedClustersAllPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ProvisionedClustersAllPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jtctiilusspsdsuu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameter for the name of the provisioned cluster
     */
    @JvmName("enbcwvnhmtkbdflq")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("magrinvbwblqvdua")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nbynwcgbqmitbqkd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProvisionedClusterArgs = ProvisionedClusterArgs(
        extendedLocation = extendedLocation,
        identity = identity,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
    )
}
