@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin

import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.VirtualNetworksPropertiesResponse
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.VirtualNetworksResponseExtendedLocation
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.VirtualNetworksPropertiesResponse.Companion.toKotlin as virtualNetworksPropertiesResponseToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.VirtualNetworksResponseExtendedLocation.Companion.toKotlin as virtualNetworksResponseExtendedLocationToKotlin

/**
 * Builder for [VirtualNetworkRetrieve].
 */
@PulumiTagMarker
public class VirtualNetworkRetrieveResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualNetworkRetrieveArgs = VirtualNetworkRetrieveArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualNetworkRetrieveArgsBuilder.() -> Unit) {
        val builder = VirtualNetworkRetrieveArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualNetworkRetrieve {
        val builtJavaResource =
            com.pulumi.azurenative.hybridcontainerservice.VirtualNetworkRetrieve(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualNetworkRetrieve(builtJavaResource)
    }
}

/**
 * The virtualNetworks resource definition.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * ## Example Usage
 * ### PutVirtualNetwork
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkRetrieve = new AzureNative.HybridContainerService.VirtualNetworkRetrieve("virtualNetworkRetrieve", new()
 *     {
 *         ExtendedLocation = new AzureNative.HybridContainerService.Inputs.VirtualNetworksExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation",
 *             Type = "CustomLocation",
 *         },
 *         Location = "westus",
 *         Properties = new AzureNative.HybridContainerService.Inputs.VirtualNetworksPropertiesArgs
 *         {
 *             InfraVnetProfile = new AzureNative.HybridContainerService.Inputs.VirtualNetworksPropertiesInfraVnetProfileArgs
 *             {
 *                 Hci = new AzureNative.HybridContainerService.Inputs.VirtualNetworksPropertiesHciArgs
 *                 {
 *                     MocGroup = "target-group",
 *                     MocLocation = "MocLocation",
 *                     MocVnetName = "test-vnet",
 *                 },
 *             },
 *             VipPool = new[]
 *             {
 *                 new AzureNative.HybridContainerService.Inputs.VirtualNetworksPropertiesVipPoolArgs
 *                 {
 *                     EndIP = "192.168.0.50",
 *                     StartIP = "192.168.0.10",
 *                 },
 *             },
 *             VmipPool = new[]
 *             {
 *                 new AzureNative.HybridContainerService.Inputs.VirtualNetworksPropertiesVmipPoolArgs
 *                 {
 *                     EndIP = "192.168.0.130",
 *                     StartIP = "192.168.0.110",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "test-arcappliance-resgrp",
 *         VirtualNetworksName = "test-vnet-static",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcontainerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcontainerservice.NewVirtualNetworkRetrieve(ctx, "virtualNetworkRetrieve", &hybridcontainerservice.VirtualNetworkRetrieveArgs{
 * 			ExtendedLocation: &hybridcontainerservice.VirtualNetworksExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Properties: &hybridcontainerservice.VirtualNetworksPropertiesArgs{
 * 				InfraVnetProfile: &hybridcontainerservice.VirtualNetworksPropertiesInfraVnetProfileArgs{
 * 					Hci: &hybridcontainerservice.VirtualNetworksPropertiesHciArgs{
 * 						MocGroup:    pulumi.String("target-group"),
 * 						MocLocation: pulumi.String("MocLocation"),
 * 						MocVnetName: pulumi.String("test-vnet"),
 * 					},
 * 				},
 * 				VipPool: hybridcontainerservice.VirtualNetworksPropertiesVipPoolArray{
 * 					&hybridcontainerservice.VirtualNetworksPropertiesVipPoolArgs{
 * 						EndIP:   pulumi.String("192.168.0.50"),
 * 						StartIP: pulumi.String("192.168.0.10"),
 * 					},
 * 				},
 * 				VmipPool: hybridcontainerservice.VirtualNetworksPropertiesVmipPoolArray{
 * 					&hybridcontainerservice.VirtualNetworksPropertiesVmipPoolArgs{
 * 						EndIP:   pulumi.String("192.168.0.130"),
 * 						StartIP: pulumi.String("192.168.0.110"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName:   pulumi.String("test-arcappliance-resgrp"),
 * 			VirtualNetworksName: pulumi.String("test-vnet-static"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcontainerservice.VirtualNetworkRetrieve;
 * import com.pulumi.azurenative.hybridcontainerservice.VirtualNetworkRetrieveArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksExtendedLocationArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesInfraVnetProfileArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesHciArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkRetrieve = new VirtualNetworkRetrieve("virtualNetworkRetrieve", VirtualNetworkRetrieveArgs.builder()
 *             .extendedLocation(VirtualNetworksExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("westus")
 *             .properties(VirtualNetworksPropertiesArgs.builder()
 *                 .infraVnetProfile(VirtualNetworksPropertiesInfraVnetProfileArgs.builder()
 *                     .hci(VirtualNetworksPropertiesHciArgs.builder()
 *                         .mocGroup("target-group")
 *                         .mocLocation("MocLocation")
 *                         .mocVnetName("test-vnet")
 *                         .build())
 *                     .build())
 *                 .vipPool(VirtualNetworksPropertiesVipPoolArgs.builder()
 *                     .endIP("192.168.0.50")
 *                     .startIP("192.168.0.10")
 *                     .build())
 *                 .vmipPool(VirtualNetworksPropertiesVmipPoolArgs.builder()
 *                     .endIP("192.168.0.130")
 *                     .startIP("192.168.0.110")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("test-arcappliance-resgrp")
 *             .virtualNetworksName("test-vnet-static")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcontainerservice:VirtualNetworkRetrieve test-vnet-static /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/virtualNetworks/{virtualNetworksName}
 * ```
 */
public class VirtualNetworkRetrieve internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridcontainerservice.VirtualNetworkRetrieve,
) : KotlinCustomResource(javaResource, VirtualNetworkRetrieveMapper) {
    public val extendedLocation: Output<VirtualNetworksResponseExtendedLocation>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualNetworksResponseExtendedLocationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * HybridAKSNetworkSpec defines the desired state of HybridAKSNetwork
     */
    public val properties: Output<VirtualNetworksPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualNetworksPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VirtualNetworkRetrieveMapper : ResourceMapper<VirtualNetworkRetrieve> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridcontainerservice.VirtualNetworkRetrieve::class == javaResource::class

    override fun map(javaResource: Resource): VirtualNetworkRetrieve =
        VirtualNetworkRetrieve(
            javaResource as
                com.pulumi.azurenative.hybridcontainerservice.VirtualNetworkRetrieve,
        )
}

/**
 * @see [VirtualNetworkRetrieve].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualNetworkRetrieve].
 */
public suspend fun virtualNetworkRetrieve(
    name: String,
    block: suspend VirtualNetworkRetrieveResourceBuilder.() -> Unit,
): VirtualNetworkRetrieve {
    val builder = VirtualNetworkRetrieveResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualNetworkRetrieve].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualNetworkRetrieve(name: String): VirtualNetworkRetrieve {
    val builder = VirtualNetworkRetrieveResourceBuilder()
    builder.name(name)
    return builder.build()
}
