@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * LoadBalancerSku - The load balancer sku for the provisioned cluster. Possible values: 'unstacked-haproxy', 'stacked-kube-vip', 'stacked-metallb', 'unmanaged'. The default is 'unmanaged'.
 */
public enum class LoadBalancerSku(
    public val javaValue: com.pulumi.azurenative.hybridcontainerservice.enums.LoadBalancerSku,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.enums.LoadBalancerSku> {
    Unstackedhaproxy(com.pulumi.azurenative.hybridcontainerservice.enums.LoadBalancerSku.Unstackedhaproxy),
    Stackedkubevip(com.pulumi.azurenative.hybridcontainerservice.enums.LoadBalancerSku.Stackedkubevip),
    Stackedmetallb(com.pulumi.azurenative.hybridcontainerservice.enums.LoadBalancerSku.Stackedmetallb),
    Unmanaged(com.pulumi.azurenative.hybridcontainerservice.enums.LoadBalancerSku.Unmanaged),
    ;

    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.enums.LoadBalancerSku =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.enums.LoadBalancerSku): LoadBalancerSku = LoadBalancerSku.values().first { it.javaValue == javaType }
    }
}
