@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico', 'flannel'. Default is 'calico'
 */
public enum class NetworkPolicy(
    public val javaValue: com.pulumi.azurenative.hybridcontainerservice.enums.NetworkPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.enums.NetworkPolicy> {
    Calico(com.pulumi.azurenative.hybridcontainerservice.enums.NetworkPolicy.Calico),
    Flannel(com.pulumi.azurenative.hybridcontainerservice.enums.NetworkPolicy.Flannel),
    ;

    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.enums.NetworkPolicy =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.enums.NetworkPolicy): NetworkPolicy = NetworkPolicy.values().first { it.javaValue == javaType }
    }
}
