@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
 */
public enum class OsType(
    public val javaValue: com.pulumi.azurenative.hybridcontainerservice.enums.OsType,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.enums.OsType> {
    Linux(com.pulumi.azurenative.hybridcontainerservice.enums.OsType.Linux),
    Windows(com.pulumi.azurenative.hybridcontainerservice.enums.OsType.Windows),
    ;

    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.enums.OsType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.enums.OsType): OsType = OsType.values().first { it.javaValue == javaType }
    }
}
