@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the provisioned cluster. The type SystemAssigned, includes a system created identity. The type None means no identity is assigned to the provisioned cluster.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.hybridcontainerservice.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.enums.ResourceIdentityType> {
    None(com.pulumi.azurenative.hybridcontainerservice.enums.ResourceIdentityType.None),
    SystemAssigned(com.pulumi.azurenative.hybridcontainerservice.enums.ResourceIdentityType.SystemAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.enums.ResourceIdentityType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
