@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.AgentPoolProvisioningStatusErrorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property code
 * @property message
 */
public data class AgentPoolProvisioningStatusErrorArgs(
    public val code: Output<String>? = null,
    public val message: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.AgentPoolProvisioningStatusErrorArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.AgentPoolProvisioningStatusErrorArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.AgentPoolProvisioningStatusErrorArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentPoolProvisioningStatusErrorArgs].
 */
@PulumiTagMarker
public class AgentPoolProvisioningStatusErrorArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var message: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("facrbbklqwdvqrua")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value
     */
    @JvmName("tmqyxywlkouncobi")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value
     */
    @JvmName("tsiklftvtmkyucrw")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value
     */
    @JvmName("nqufncoqgmdhdgfg")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    internal fun build(): AgentPoolProvisioningStatusErrorArgs = AgentPoolProvisioningStatusErrorArgs(
        code = code,
        message = message,
    )
}
