@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.AgentPoolProvisioningStatusProvisioningStatusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Contains Provisioning errors
 * @property error
 * @property operationId
 * @property phase Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
 * @property status
 */
public data class AgentPoolProvisioningStatusProvisioningStatusArgs(
    public val error: Output<AgentPoolProvisioningStatusErrorArgs>? = null,
    public val operationId: Output<String>? = null,
    public val phase: Output<String>? = null,
    public val status: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.AgentPoolProvisioningStatusProvisioningStatusArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.AgentPoolProvisioningStatusProvisioningStatusArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.AgentPoolProvisioningStatusProvisioningStatusArgs.builder()
            .error(error?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .operationId(operationId?.applyValue({ args0 -> args0 }))
            .phase(phase?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentPoolProvisioningStatusProvisioningStatusArgs].
 */
@PulumiTagMarker
public class AgentPoolProvisioningStatusProvisioningStatusArgsBuilder internal constructor() {
    private var error: Output<AgentPoolProvisioningStatusErrorArgs>? = null

    private var operationId: Output<String>? = null

    private var phase: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("sgcevjgqjjjyfdvv")
    public suspend fun error(`value`: Output<AgentPoolProvisioningStatusErrorArgs>) {
        this.error = value
    }

    /**
     * @param value
     */
    @JvmName("jqkfcfhrseeokwvl")
    public suspend fun operationId(`value`: Output<String>) {
        this.operationId = value
    }

    /**
     * @param value Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
     */
    @JvmName("tliwituqxskusrjf")
    public suspend fun phase(`value`: Output<String>) {
        this.phase = value
    }

    /**
     * @param value
     */
    @JvmName("vkqbkrcgkucpgysr")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value
     */
    @JvmName("cbewpajhaqsxkbwd")
    public suspend fun error(`value`: AgentPoolProvisioningStatusErrorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.error = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lpqqvvrpdtbyebwu")
    public suspend fun error(argument: suspend AgentPoolProvisioningStatusErrorArgsBuilder.() -> Unit) {
        val toBeMapped = AgentPoolProvisioningStatusErrorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.error = mapped
    }

    /**
     * @param value
     */
    @JvmName("vejwlrhlejsktbuf")
    public suspend fun operationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationId = mapped
    }

    /**
     * @param value Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
     */
    @JvmName("fmnuflotclsmhafy")
    public suspend fun phase(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phase = mapped
    }

    /**
     * @param value
     */
    @JvmName("gfkehovrikggynwc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): AgentPoolProvisioningStatusProvisioningStatusArgs =
        AgentPoolProvisioningStatusProvisioningStatusArgs(
            error = error,
            operationId = operationId,
            phase = phase,
            status = status,
        )
}
