@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.ArcAgentProfileArgs.builder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.enums.AutoUpgradeOptions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the Arc Agent properties for the Provisioned clusters.
 * @property agentAutoUpgrade Indicates whether the Arc agents on the provisioned clusters be upgraded automatically to the latest version. Defaults to Enabled.
 * @property agentVersion Version of the Arc agents to be installed on the provisioned Provisioned cluster resource
 */
public data class ArcAgentProfileArgs(
    public val agentAutoUpgrade: Output<Either<String, AutoUpgradeOptions>>? = null,
    public val agentVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.ArcAgentProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.ArcAgentProfileArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.ArcAgentProfileArgs.builder()
            .agentAutoUpgrade(
                agentAutoUpgrade?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .agentVersion(agentVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArcAgentProfileArgs].
 */
@PulumiTagMarker
public class ArcAgentProfileArgsBuilder internal constructor() {
    private var agentAutoUpgrade: Output<Either<String, AutoUpgradeOptions>>? = null

    private var agentVersion: Output<String>? = null

    /**
     * @param value Indicates whether the Arc agents on the provisioned clusters be upgraded automatically to the latest version. Defaults to Enabled.
     */
    @JvmName("yojpwgdyovrrvcpq")
    public suspend fun agentAutoUpgrade(`value`: Output<Either<String, AutoUpgradeOptions>>) {
        this.agentAutoUpgrade = value
    }

    /**
     * @param value Version of the Arc agents to be installed on the provisioned Provisioned cluster resource
     */
    @JvmName("ynbsjhnsvbatdngt")
    public suspend fun agentVersion(`value`: Output<String>) {
        this.agentVersion = value
    }

    /**
     * @param value Indicates whether the Arc agents on the provisioned clusters be upgraded automatically to the latest version. Defaults to Enabled.
     */
    @JvmName("kxkceuycbvodvmrc")
    public suspend fun agentAutoUpgrade(`value`: Either<String, AutoUpgradeOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentAutoUpgrade = mapped
    }

    /**
     * @param value Indicates whether the Arc agents on the provisioned clusters be upgraded automatically to the latest version. Defaults to Enabled.
     */
    @JvmName("jqxkwddmlgihasso")
    public fun agentAutoUpgrade(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoUpgradeOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentAutoUpgrade = mapped
    }

    /**
     * @param value Indicates whether the Arc agents on the provisioned clusters be upgraded automatically to the latest version. Defaults to Enabled.
     */
    @JvmName("lybxirapuejwivke")
    public fun agentAutoUpgrade(`value`: AutoUpgradeOptions) {
        val toBeMapped = Either.ofRight<String, AutoUpgradeOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentAutoUpgrade = mapped
    }

    /**
     * @param value Version of the Arc agents to be installed on the provisioned Provisioned cluster resource
     */
    @JvmName("yukvpgeedgoglype")
    public suspend fun agentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentVersion = mapped
    }

    internal fun build(): ArcAgentProfileArgs = ArcAgentProfileArgs(
        agentAutoUpgrade = agentAutoUpgrade,
        agentVersion = agentVersion,
    )
}
