@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.GetProvisionedClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName Parameter for the name of the provisioned cluster
 */
public data class GetProvisionedClusterPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.GetProvisionedClusterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.GetProvisionedClusterPlainArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.GetProvisionedClusterPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProvisionedClusterPlainArgs].
 */
@PulumiTagMarker
public class GetProvisionedClusterPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("odgtnplyurmiigke")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameter for the name of the provisioned cluster
     */
    @JvmName("bxvcnbmbuwahcsix")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetProvisionedClusterPlainArgs = GetProvisionedClusterPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
