@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.GetStorageSpaceRetrievePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageSpacesName Parameter for the name of the storage object
 */
public data class GetStorageSpaceRetrievePlainArgs(
    public val resourceGroupName: String,
    public val storageSpacesName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.GetStorageSpaceRetrievePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.GetStorageSpaceRetrievePlainArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.GetStorageSpaceRetrievePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageSpacesName(storageSpacesName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageSpaceRetrievePlainArgs].
 */
@PulumiTagMarker
public class GetStorageSpaceRetrievePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var storageSpacesName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xsasevbokvdnelha")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameter for the name of the storage object
     */
    @JvmName("wjoadeqlkwmkhggl")
    public suspend fun storageSpacesName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageSpacesName = mapped
    }

    internal fun build(): GetStorageSpaceRetrievePlainArgs = GetStorageSpaceRetrievePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageSpacesName = storageSpacesName ?: throw PulumiNullFieldException("storageSpacesName"),
    )
}
