@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesSshArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SSH - SSH configuration for Linux-based VMs running on Azure.
 * @property publicKeys PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
 */
public data class LinuxProfilePropertiesSshArgs(
    public val publicKeys: Output<List<LinuxProfilePropertiesPublicKeysArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesSshArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesSshArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.LinuxProfilePropertiesSshArgs.builder()
            .publicKeys(
                publicKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [LinuxProfilePropertiesSshArgs].
 */
@PulumiTagMarker
public class LinuxProfilePropertiesSshArgsBuilder internal constructor() {
    private var publicKeys: Output<List<LinuxProfilePropertiesPublicKeysArgs>>? = null

    /**
     * @param value PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
     */
    @JvmName("asnkgtokldyhprnq")
    public suspend fun publicKeys(`value`: Output<List<LinuxProfilePropertiesPublicKeysArgs>>) {
        this.publicKeys = value
    }

    @JvmName("wtjybpateutbadbt")
    public suspend fun publicKeys(vararg values: Output<LinuxProfilePropertiesPublicKeysArgs>) {
        this.publicKeys = Output.all(values.asList())
    }

    /**
     * @param values PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
     */
    @JvmName("pjbreqlpsqipdwmn")
    public suspend fun publicKeys(values: List<Output<LinuxProfilePropertiesPublicKeysArgs>>) {
        this.publicKeys = Output.all(values)
    }

    /**
     * @param value PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
     */
    @JvmName("euiyywofoqumarsp")
    public suspend fun publicKeys(`value`: List<LinuxProfilePropertiesPublicKeysArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    /**
     * @param argument PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
     */
    @JvmName("yjsuqhpwgldmiyaw")
    public suspend fun publicKeys(argument: List<suspend LinuxProfilePropertiesPublicKeysArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinuxProfilePropertiesPublicKeysArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param argument PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
     */
    @JvmName("phyxdygtmpwbgcbn")
    public suspend fun publicKeys(vararg argument: suspend LinuxProfilePropertiesPublicKeysArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LinuxProfilePropertiesPublicKeysArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param argument PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
     */
    @JvmName("tsbhmmhjgsuyxthg")
    public suspend fun publicKeys(argument: suspend LinuxProfilePropertiesPublicKeysArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LinuxProfilePropertiesPublicKeysArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param values PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
     */
    @JvmName("jpjydngcocqffwwh")
    public suspend fun publicKeys(vararg values: LinuxProfilePropertiesPublicKeysArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    internal fun build(): LinuxProfilePropertiesSshArgs = LinuxProfilePropertiesSshArgs(
        publicKeys = publicKeys,
    )
}
