@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClusterIdentityArgs.builder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity for the Provisioned cluster.
 * @property type The type of identity used for the provisioned cluster. The type SystemAssigned, includes a system created identity. The type None means no identity is assigned to the provisioned cluster.
 */
public data class ProvisionedClusterIdentityArgs(
    public val type: Output<ResourceIdentityType>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClusterIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClusterIdentityArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClusterIdentityArgs.builder()
            .type(type.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ProvisionedClusterIdentityArgs].
 */
@PulumiTagMarker
public class ProvisionedClusterIdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    /**
     * @param value The type of identity used for the provisioned cluster. The type SystemAssigned, includes a system created identity. The type None means no identity is assigned to the provisioned cluster.
     */
    @JvmName("mudotcpyfbpwrndb")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The type of identity used for the provisioned cluster. The type SystemAssigned, includes a system created identity. The type None means no identity is assigned to the provisioned cluster.
     */
    @JvmName("lqjqelynogqldhur")
    public suspend fun type(`value`: ResourceIdentityType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProvisionedClusterIdentityArgs = ProvisionedClusterIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
