@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersAllPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * All properties of the provisioned cluster
 * @property aadProfile AAD profile for the provisioned cluster.
 * @property addonProfiles AddonProfiles - Profile of managed cluster add-on.
 * @property agentPoolProfiles The agent pools of the cluster.
 * @property cloudProviderProfile The underlying cloud infra provider properties.
 * @property controlPlane ControlPlane - ControlPlane Configuration
 * @property enableRbac EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
 * @property features Additional features specs like Arc Agent Onboarding.
 * @property httpProxyConfig HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
 * @property kubernetesVersion KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
 * @property linuxProfile LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
 * @property networkProfile NetworkProfile - Profile of network configuration.
 * @property nodeResourceGroup NodeResourceGroup - Name of the resource group containing agent pool nodes.
 * @property windowsProfile WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
 */
public data class ProvisionedClustersAllPropertiesArgs(
    public val aadProfile: Output<AADProfileArgs>? = null,
    public val addonProfiles: Output<Map<String, AddonProfilesArgs>>? = null,
    public val agentPoolProfiles: Output<List<NamedAgentPoolProfileArgs>>? = null,
    public val cloudProviderProfile: Output<CloudProviderProfileArgs>? = null,
    public val controlPlane: Output<ControlPlaneProfileArgs>? = null,
    public val enableRbac: Output<Boolean>? = null,
    public val features: Output<ProvisionedClustersCommonPropertiesFeaturesArgs>? = null,
    public val httpProxyConfig: Output<HttpProxyConfigArgs>? = null,
    public val kubernetesVersion: Output<String>? = null,
    public val linuxProfile: Output<LinuxProfilePropertiesArgs>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val nodeResourceGroup: Output<String>? = null,
    public val windowsProfile: Output<WindowsProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersAllPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersAllPropertiesArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersAllPropertiesArgs.builder()
            .aadProfile(aadProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .addonProfiles(
                addonProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .agentPoolProfiles(
                agentPoolProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cloudProviderProfile(
                cloudProviderProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .controlPlane(controlPlane?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableRbac(enableRbac?.applyValue({ args0 -> args0 }))
            .features(features?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpProxyConfig(httpProxyConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kubernetesVersion(kubernetesVersion?.applyValue({ args0 -> args0 }))
            .linuxProfile(linuxProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nodeResourceGroup(nodeResourceGroup?.applyValue({ args0 -> args0 }))
            .windowsProfile(
                windowsProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ProvisionedClustersAllPropertiesArgs].
 */
@PulumiTagMarker
public class ProvisionedClustersAllPropertiesArgsBuilder internal constructor() {
    private var aadProfile: Output<AADProfileArgs>? = null

    private var addonProfiles: Output<Map<String, AddonProfilesArgs>>? = null

    private var agentPoolProfiles: Output<List<NamedAgentPoolProfileArgs>>? = null

    private var cloudProviderProfile: Output<CloudProviderProfileArgs>? = null

    private var controlPlane: Output<ControlPlaneProfileArgs>? = null

    private var enableRbac: Output<Boolean>? = null

    private var features: Output<ProvisionedClustersCommonPropertiesFeaturesArgs>? = null

    private var httpProxyConfig: Output<HttpProxyConfigArgs>? = null

    private var kubernetesVersion: Output<String>? = null

    private var linuxProfile: Output<LinuxProfilePropertiesArgs>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var nodeResourceGroup: Output<String>? = null

    private var windowsProfile: Output<WindowsProfileArgs>? = null

    /**
     * @param value AAD profile for the provisioned cluster.
     */
    @JvmName("hvevcfipulcotkap")
    public suspend fun aadProfile(`value`: Output<AADProfileArgs>) {
        this.aadProfile = value
    }

    /**
     * @param value AddonProfiles - Profile of managed cluster add-on.
     */
    @JvmName("vikaahshjrxdttfd")
    public suspend fun addonProfiles(`value`: Output<Map<String, AddonProfilesArgs>>) {
        this.addonProfiles = value
    }

    /**
     * @param value The agent pools of the cluster.
     */
    @JvmName("cljpdtkpweowvdji")
    public suspend fun agentPoolProfiles(`value`: Output<List<NamedAgentPoolProfileArgs>>) {
        this.agentPoolProfiles = value
    }

    @JvmName("seodsbbgdaylaemu")
    public suspend fun agentPoolProfiles(vararg values: Output<NamedAgentPoolProfileArgs>) {
        this.agentPoolProfiles = Output.all(values.asList())
    }

    /**
     * @param values The agent pools of the cluster.
     */
    @JvmName("wildurhbbwagmawg")
    public suspend fun agentPoolProfiles(values: List<Output<NamedAgentPoolProfileArgs>>) {
        this.agentPoolProfiles = Output.all(values)
    }

    /**
     * @param value The underlying cloud infra provider properties.
     */
    @JvmName("acejbfdejenotgyq")
    public suspend fun cloudProviderProfile(`value`: Output<CloudProviderProfileArgs>) {
        this.cloudProviderProfile = value
    }

    /**
     * @param value ControlPlane - ControlPlane Configuration
     */
    @JvmName("iflcajrfhpylxyer")
    public suspend fun controlPlane(`value`: Output<ControlPlaneProfileArgs>) {
        this.controlPlane = value
    }

    /**
     * @param value EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
     */
    @JvmName("nxwvvbtbaghhmiwu")
    public suspend fun enableRbac(`value`: Output<Boolean>) {
        this.enableRbac = value
    }

    /**
     * @param value Additional features specs like Arc Agent Onboarding.
     */
    @JvmName("kubyfhmkafxocwhj")
    public suspend fun features(`value`: Output<ProvisionedClustersCommonPropertiesFeaturesArgs>) {
        this.features = value
    }

    /**
     * @param value HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JvmName("medycktjwjbnsawh")
    public suspend fun httpProxyConfig(`value`: Output<HttpProxyConfigArgs>) {
        this.httpProxyConfig = value
    }

    /**
     * @param value KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
     */
    @JvmName("hnxkhipgomrpeqsg")
    public suspend fun kubernetesVersion(`value`: Output<String>) {
        this.kubernetesVersion = value
    }

    /**
     * @param value LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
     */
    @JvmName("adqfiuftfjodhumx")
    public suspend fun linuxProfile(`value`: Output<LinuxProfilePropertiesArgs>) {
        this.linuxProfile = value
    }

    /**
     * @param value NetworkProfile - Profile of network configuration.
     */
    @JvmName("gaypajnoqosqwefh")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value NodeResourceGroup - Name of the resource group containing agent pool nodes.
     */
    @JvmName("dtlileawlbqidjsu")
    public suspend fun nodeResourceGroup(`value`: Output<String>) {
        this.nodeResourceGroup = value
    }

    /**
     * @param value WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
     */
    @JvmName("ceuhjrbrdlrgdaqw")
    public suspend fun windowsProfile(`value`: Output<WindowsProfileArgs>) {
        this.windowsProfile = value
    }

    /**
     * @param value AAD profile for the provisioned cluster.
     */
    @JvmName("axalqqkvwgekkgba")
    public suspend fun aadProfile(`value`: AADProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadProfile = mapped
    }

    /**
     * @param argument AAD profile for the provisioned cluster.
     */
    @JvmName("qhmjrkteaqyacdpn")
    public suspend fun aadProfile(argument: suspend AADProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AADProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aadProfile = mapped
    }

    /**
     * @param value AddonProfiles - Profile of managed cluster add-on.
     */
    @JvmName("mqgrweokrdcuibse")
    public suspend fun addonProfiles(`value`: Map<String, AddonProfilesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonProfiles = mapped
    }

    /**
     * @param argument AddonProfiles - Profile of managed cluster add-on.
     */
    @JvmName("bxlidctabtxncbjl")
    public suspend fun addonProfiles(vararg argument: Pair<String, suspend AddonProfilesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                AddonProfilesArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.addonProfiles = mapped
    }

    /**
     * @param values AddonProfiles - Profile of managed cluster add-on.
     */
    @JvmName("kbygtbcjkqllhfsn")
    public fun addonProfiles(vararg values: Pair<String, AddonProfilesArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addonProfiles = mapped
    }

    /**
     * @param value The agent pools of the cluster.
     */
    @JvmName("fumlopsetmdcdect")
    public suspend fun agentPoolProfiles(`value`: List<NamedAgentPoolProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument The agent pools of the cluster.
     */
    @JvmName("hnuhcskfpaprvlnl")
    public suspend fun agentPoolProfiles(argument: List<suspend NamedAgentPoolProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NamedAgentPoolProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument The agent pools of the cluster.
     */
    @JvmName("nqfuxbcgebjogqva")
    public suspend fun agentPoolProfiles(vararg argument: suspend NamedAgentPoolProfileArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NamedAgentPoolProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument The agent pools of the cluster.
     */
    @JvmName("sxdbrycyjbbbuown")
    public suspend fun agentPoolProfiles(argument: suspend NamedAgentPoolProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NamedAgentPoolProfileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param values The agent pools of the cluster.
     */
    @JvmName("phlnfjgkqegwnmjf")
    public suspend fun agentPoolProfiles(vararg values: NamedAgentPoolProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentPoolProfiles = mapped
    }

    /**
     * @param value The underlying cloud infra provider properties.
     */
    @JvmName("boxevalcxwmteaiv")
    public suspend fun cloudProviderProfile(`value`: CloudProviderProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudProviderProfile = mapped
    }

    /**
     * @param argument The underlying cloud infra provider properties.
     */
    @JvmName("djmricsjejcjsnwu")
    public suspend fun cloudProviderProfile(argument: suspend CloudProviderProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CloudProviderProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cloudProviderProfile = mapped
    }

    /**
     * @param value ControlPlane - ControlPlane Configuration
     */
    @JvmName("kuiehxmfuagnuqdr")
    public suspend fun controlPlane(`value`: ControlPlaneProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPlane = mapped
    }

    /**
     * @param argument ControlPlane - ControlPlane Configuration
     */
    @JvmName("wovilfbqnjhlgpxw")
    public suspend fun controlPlane(argument: suspend ControlPlaneProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ControlPlaneProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.controlPlane = mapped
    }

    /**
     * @param value EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
     */
    @JvmName("mywwibktmkagjklv")
    public suspend fun enableRbac(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRbac = mapped
    }

    /**
     * @param value Additional features specs like Arc Agent Onboarding.
     */
    @JvmName("cmxhiyussxrwhmej")
    public suspend fun features(`value`: ProvisionedClustersCommonPropertiesFeaturesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param argument Additional features specs like Arc Agent Onboarding.
     */
    @JvmName("axpnmnhhwsfhpakx")
    public suspend fun features(argument: suspend ProvisionedClustersCommonPropertiesFeaturesArgsBuilder.() -> Unit) {
        val toBeMapped = ProvisionedClustersCommonPropertiesFeaturesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.features = mapped
    }

    /**
     * @param value HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JvmName("klembqoujbiepqac")
    public suspend fun httpProxyConfig(`value`: HttpProxyConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProxyConfig = mapped
    }

    /**
     * @param argument HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JvmName("plusiwcmboqrodts")
    public suspend fun httpProxyConfig(argument: suspend HttpProxyConfigArgsBuilder.() -> Unit) {
        val toBeMapped = HttpProxyConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpProxyConfig = mapped
    }

    /**
     * @param value KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
     */
    @JvmName("tectfwtvwldfakvp")
    public suspend fun kubernetesVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesVersion = mapped
    }

    /**
     * @param value LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
     */
    @JvmName("crqcieoknfascecl")
    public suspend fun linuxProfile(`value`: LinuxProfilePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxProfile = mapped
    }

    /**
     * @param argument LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
     */
    @JvmName("evahenbsbxfbpjnx")
    public suspend fun linuxProfile(argument: suspend LinuxProfilePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = LinuxProfilePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linuxProfile = mapped
    }

    /**
     * @param value NetworkProfile - Profile of network configuration.
     */
    @JvmName("nqtibjpsjhsmrssy")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument NetworkProfile - Profile of network configuration.
     */
    @JvmName("vianxaksrkasrlgi")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value NodeResourceGroup - Name of the resource group containing agent pool nodes.
     */
    @JvmName("cgueqvrtjqglwtob")
    public suspend fun nodeResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeResourceGroup = mapped
    }

    /**
     * @param value WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
     */
    @JvmName("tbtckxngbtlhcoxo")
    public suspend fun windowsProfile(`value`: WindowsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsProfile = mapped
    }

    /**
     * @param argument WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
     */
    @JvmName("pilhdplafcptfviu")
    public suspend fun windowsProfile(argument: suspend WindowsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsProfile = mapped
    }

    internal fun build(): ProvisionedClustersAllPropertiesArgs = ProvisionedClustersAllPropertiesArgs(
        aadProfile = aadProfile,
        addonProfiles = addonProfiles,
        agentPoolProfiles = agentPoolProfiles,
        cloudProviderProfile = cloudProviderProfile,
        controlPlane = controlPlane,
        enableRbac = enableRbac,
        features = features,
        httpProxyConfig = httpProxyConfig,
        kubernetesVersion = kubernetesVersion,
        linuxProfile = linuxProfile,
        networkProfile = networkProfile,
        nodeResourceGroup = nodeResourceGroup,
        windowsProfile = windowsProfile,
    )
}
