@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * HybridAKSNetworkSpec defines the desired state of HybridAKSNetwork
 * @property dnsServers Address of the DNS servers associated with the network
 * @property gateway Address of the Gateway associated with the network
 * @property infraVnetProfile
 * @property ipAddressPrefix IP Address Prefix of the network
 * @property vipPool Virtual IP Pool for Kubernetes
 * @property vmipPool IP Pool for Virtual Machines
 */
public data class VirtualNetworksPropertiesArgs(
    public val dnsServers: Output<List<String>>? = null,
    public val gateway: Output<String>? = null,
    public val infraVnetProfile: Output<VirtualNetworksPropertiesInfraVnetProfileArgs>? = null,
    public val ipAddressPrefix: Output<String>? = null,
    public val vipPool: Output<List<VirtualNetworksPropertiesVipPoolArgs>>? = null,
    public val vmipPool: Output<List<VirtualNetworksPropertiesVmipPoolArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesArgs.builder()
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .gateway(gateway?.applyValue({ args0 -> args0 }))
            .infraVnetProfile(infraVnetProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipAddressPrefix(ipAddressPrefix?.applyValue({ args0 -> args0 }))
            .vipPool(
                vipPool?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vmipPool(
                vmipPool?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworksPropertiesArgs].
 */
@PulumiTagMarker
public class VirtualNetworksPropertiesArgsBuilder internal constructor() {
    private var dnsServers: Output<List<String>>? = null

    private var gateway: Output<String>? = null

    private var infraVnetProfile: Output<VirtualNetworksPropertiesInfraVnetProfileArgs>? = null

    private var ipAddressPrefix: Output<String>? = null

    private var vipPool: Output<List<VirtualNetworksPropertiesVipPoolArgs>>? = null

    private var vmipPool: Output<List<VirtualNetworksPropertiesVmipPoolArgs>>? = null

    /**
     * @param value Address of the DNS servers associated with the network
     */
    @JvmName("pywvqpithiwofgrs")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("rngbxwdnfaahxdvr")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values Address of the DNS servers associated with the network
     */
    @JvmName("knvpbonqymndagwt")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value Address of the Gateway associated with the network
     */
    @JvmName("xqoqstjsusbkkaub")
    public suspend fun gateway(`value`: Output<String>) {
        this.gateway = value
    }

    /**
     * @param value
     */
    @JvmName("sbcoypdylkwkjycm")
    public suspend fun infraVnetProfile(`value`: Output<VirtualNetworksPropertiesInfraVnetProfileArgs>) {
        this.infraVnetProfile = value
    }

    /**
     * @param value IP Address Prefix of the network
     */
    @JvmName("hrsxkcoropiiirec")
    public suspend fun ipAddressPrefix(`value`: Output<String>) {
        this.ipAddressPrefix = value
    }

    /**
     * @param value Virtual IP Pool for Kubernetes
     */
    @JvmName("qomhcbhontbnwbaa")
    public suspend fun vipPool(`value`: Output<List<VirtualNetworksPropertiesVipPoolArgs>>) {
        this.vipPool = value
    }

    @JvmName("qxonfoqtyddwbloo")
    public suspend fun vipPool(vararg values: Output<VirtualNetworksPropertiesVipPoolArgs>) {
        this.vipPool = Output.all(values.asList())
    }

    /**
     * @param values Virtual IP Pool for Kubernetes
     */
    @JvmName("btdsccmcbdnkoyjq")
    public suspend fun vipPool(values: List<Output<VirtualNetworksPropertiesVipPoolArgs>>) {
        this.vipPool = Output.all(values)
    }

    /**
     * @param value IP Pool for Virtual Machines
     */
    @JvmName("nldfmwxxloeorxub")
    public suspend fun vmipPool(`value`: Output<List<VirtualNetworksPropertiesVmipPoolArgs>>) {
        this.vmipPool = value
    }

    @JvmName("eqapbuvmxkybekfp")
    public suspend fun vmipPool(vararg values: Output<VirtualNetworksPropertiesVmipPoolArgs>) {
        this.vmipPool = Output.all(values.asList())
    }

    /**
     * @param values IP Pool for Virtual Machines
     */
    @JvmName("ofwppocpmiovqfqt")
    public suspend fun vmipPool(values: List<Output<VirtualNetworksPropertiesVmipPoolArgs>>) {
        this.vmipPool = Output.all(values)
    }

    /**
     * @param value Address of the DNS servers associated with the network
     */
    @JvmName("cumijfjgurrmhctl")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values Address of the DNS servers associated with the network
     */
    @JvmName("yibgghotimnjkfog")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value Address of the Gateway associated with the network
     */
    @JvmName("rrykdmnujdegyrfh")
    public suspend fun gateway(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gateway = mapped
    }

    /**
     * @param value
     */
    @JvmName("ispgjhikedwjffyo")
    public suspend fun infraVnetProfile(`value`: VirtualNetworksPropertiesInfraVnetProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infraVnetProfile = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uuyclrldvwxaxtwv")
    public suspend fun infraVnetProfile(argument: suspend VirtualNetworksPropertiesInfraVnetProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworksPropertiesInfraVnetProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.infraVnetProfile = mapped
    }

    /**
     * @param value IP Address Prefix of the network
     */
    @JvmName("evwvnupvhoqbmfjx")
    public suspend fun ipAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressPrefix = mapped
    }

    /**
     * @param value Virtual IP Pool for Kubernetes
     */
    @JvmName("imgudnimagcqlhgr")
    public suspend fun vipPool(`value`: List<VirtualNetworksPropertiesVipPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vipPool = mapped
    }

    /**
     * @param argument Virtual IP Pool for Kubernetes
     */
    @JvmName("wdsuugknifkunvmr")
    public suspend fun vipPool(argument: List<suspend VirtualNetworksPropertiesVipPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworksPropertiesVipPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vipPool = mapped
    }

    /**
     * @param argument Virtual IP Pool for Kubernetes
     */
    @JvmName("ejsqpbniydumbudi")
    public suspend fun vipPool(vararg argument: suspend VirtualNetworksPropertiesVipPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNetworksPropertiesVipPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vipPool = mapped
    }

    /**
     * @param argument Virtual IP Pool for Kubernetes
     */
    @JvmName("ynwmkrpipmpuenvn")
    public suspend fun vipPool(argument: suspend VirtualNetworksPropertiesVipPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNetworksPropertiesVipPoolArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vipPool = mapped
    }

    /**
     * @param values Virtual IP Pool for Kubernetes
     */
    @JvmName("nefnlsthwadopmdj")
    public suspend fun vipPool(vararg values: VirtualNetworksPropertiesVipPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vipPool = mapped
    }

    /**
     * @param value IP Pool for Virtual Machines
     */
    @JvmName("qxchvkjcaaetdkvs")
    public suspend fun vmipPool(`value`: List<VirtualNetworksPropertiesVmipPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmipPool = mapped
    }

    /**
     * @param argument IP Pool for Virtual Machines
     */
    @JvmName("dtdmtslfggiyogvu")
    public suspend fun vmipPool(argument: List<suspend VirtualNetworksPropertiesVmipPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworksPropertiesVmipPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vmipPool = mapped
    }

    /**
     * @param argument IP Pool for Virtual Machines
     */
    @JvmName("dvhjuwjactnjilal")
    public suspend fun vmipPool(vararg argument: suspend VirtualNetworksPropertiesVmipPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNetworksPropertiesVmipPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vmipPool = mapped
    }

    /**
     * @param argument IP Pool for Virtual Machines
     */
    @JvmName("sircqsuqkxklacrh")
    public suspend fun vmipPool(argument: suspend VirtualNetworksPropertiesVmipPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNetworksPropertiesVmipPoolArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vmipPool = mapped
    }

    /**
     * @param values IP Pool for Virtual Machines
     */
    @JvmName("utdkuwrghtpqgkak")
    public suspend fun vmipPool(vararg values: VirtualNetworksPropertiesVmipPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmipPool = mapped
    }

    internal fun build(): VirtualNetworksPropertiesArgs = VirtualNetworksPropertiesArgs(
        dnsServers = dnsServers,
        gateway = gateway,
        infraVnetProfile = infraVnetProfile,
        ipAddressPrefix = ipAddressPrefix,
        vipPool = vipPool,
        vmipPool = vmipPool,
    )
}
