@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesHciArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Infra network profile for HCI platform
 * @property mocGroup Resource group in MOC(Microsoft On-premises Cloud)
 * @property mocLocation Location in MOC(Microsoft On-premises Cloud)
 * @property mocVnetName Virtual Network name in MOC(Microsoft On-premises Cloud)
 */
public data class VirtualNetworksPropertiesHciArgs(
    public val mocGroup: Output<String>? = null,
    public val mocLocation: Output<String>? = null,
    public val mocVnetName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesHciArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesHciArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesHciArgs.builder()
            .mocGroup(mocGroup?.applyValue({ args0 -> args0 }))
            .mocLocation(mocLocation?.applyValue({ args0 -> args0 }))
            .mocVnetName(mocVnetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworksPropertiesHciArgs].
 */
@PulumiTagMarker
public class VirtualNetworksPropertiesHciArgsBuilder internal constructor() {
    private var mocGroup: Output<String>? = null

    private var mocLocation: Output<String>? = null

    private var mocVnetName: Output<String>? = null

    /**
     * @param value Resource group in MOC(Microsoft On-premises Cloud)
     */
    @JvmName("wnceykmgkmywwqaw")
    public suspend fun mocGroup(`value`: Output<String>) {
        this.mocGroup = value
    }

    /**
     * @param value Location in MOC(Microsoft On-premises Cloud)
     */
    @JvmName("xrxptjuqkjcckttw")
    public suspend fun mocLocation(`value`: Output<String>) {
        this.mocLocation = value
    }

    /**
     * @param value Virtual Network name in MOC(Microsoft On-premises Cloud)
     */
    @JvmName("jlvybfwhkniuyrfg")
    public suspend fun mocVnetName(`value`: Output<String>) {
        this.mocVnetName = value
    }

    /**
     * @param value Resource group in MOC(Microsoft On-premises Cloud)
     */
    @JvmName("rwikffpnftntlcsq")
    public suspend fun mocGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mocGroup = mapped
    }

    /**
     * @param value Location in MOC(Microsoft On-premises Cloud)
     */
    @JvmName("sqbfiewnadvisddb")
    public suspend fun mocLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mocLocation = mapped
    }

    /**
     * @param value Virtual Network name in MOC(Microsoft On-premises Cloud)
     */
    @JvmName("lbnnbwpylimsrged")
    public suspend fun mocVnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mocVnetName = mapped
    }

    internal fun build(): VirtualNetworksPropertiesHciArgs = VirtualNetworksPropertiesHciArgs(
        mocGroup = mocGroup,
        mocLocation = mocLocation,
        mocVnetName = mocVnetName,
    )
}
