@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * AAD Profile specifies attributes for Azure Active Directory integration.
 * @property adminGroupObjectIDs The list of AAD group object IDs that will have admin role of the cluster.
 * @property clientAppID The client AAD application ID.
 * @property enableAzureRbac Whether to enable Azure RBAC for Kubernetes authorization.
 * @property managed Whether to enable managed AAD.
 * @property serverAppID The server AAD application ID.
 * @property tenantID The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
 */
public data class AADProfileResponseResponse(
    public val adminGroupObjectIDs: List<String>? = null,
    public val clientAppID: String? = null,
    public val enableAzureRbac: Boolean? = null,
    public val managed: Boolean? = null,
    public val serverAppID: String? = null,
    public val tenantID: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.AADProfileResponseResponse): AADProfileResponseResponse = AADProfileResponseResponse(
            adminGroupObjectIDs = javaType.adminGroupObjectIDs().map({ args0 -> args0 }),
            clientAppID = javaType.clientAppID().map({ args0 -> args0 }).orElse(null),
            enableAzureRbac = javaType.enableAzureRbac().map({ args0 -> args0 }).orElse(null),
            managed = javaType.managed().map({ args0 -> args0 }).orElse(null),
            serverAppID = javaType.serverAppID().map({ args0 -> args0 }).orElse(null),
            tenantID = javaType.tenantID().map({ args0 -> args0 }).orElse(null),
        )
    }
}
