@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the Arc Agent properties for the Provisioned clusters.
 * @property agentAutoUpgrade Indicates whether the Arc agents on the provisioned clusters be upgraded automatically to the latest version. Defaults to Enabled.
 * @property agentVersion Version of the Arc agents to be installed on the provisioned Provisioned cluster resource
 */
public data class ArcAgentProfileResponse(
    public val agentAutoUpgrade: String? = null,
    public val agentVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.ArcAgentProfileResponse): ArcAgentProfileResponse = ArcAgentProfileResponse(
            agentAutoUpgrade = javaType.agentAutoUpgrade().map({ args0 -> args0 }).orElse(null),
            agentVersion = javaType.agentVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
