@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Defines the observed Arc Agent status that is resourceSynced back to the ARM resource.
 * @property agentVersion Version of the Arc agents currently running on the Provisioned cluster resource.
 * @property coreCount Number of CPU cores present in the Provisioned cluster resource
 * @property deploymentState Observed deployment state of the Arc Agents on the target cluster. Possible values include: 'pending', 'provisioning', 'provisioned', 'deleting', 'failed', 'upgrading'
 * @property errorMessage Error messages while onboarding/upgrading/uninstalling the Arc agents
 * @property lastConnectivityTime Last connected timestamp of the Provisioned cluster resource.
 * @property managedIdentityCertificateExpirationTime ManagedIdentity certificate expiration time (ValidUntil).
 * @property onboardingPublicKey Onboarding public key for provisioning the Managed identity for the HybridAKS cluster. Will be used to create the hybridIdentityMetadata proxy resource and will not be persisted.
 */
public data class ArcAgentStatusResponse(
    public val agentVersion: String? = null,
    public val coreCount: Double? = null,
    public val deploymentState: String? = null,
    public val errorMessage: String? = null,
    public val lastConnectivityTime: String? = null,
    public val managedIdentityCertificateExpirationTime: String? = null,
    public val onboardingPublicKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.ArcAgentStatusResponse): ArcAgentStatusResponse = ArcAgentStatusResponse(
            agentVersion = javaType.agentVersion().map({ args0 -> args0 }).orElse(null),
            coreCount = javaType.coreCount().map({ args0 -> args0 }).orElse(null),
            deploymentState = javaType.deploymentState().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            lastConnectivityTime = javaType.lastConnectivityTime().map({ args0 -> args0 }).orElse(null),
            managedIdentityCertificateExpirationTime = javaType.managedIdentityCertificateExpirationTime().map({ args0 ->
                args0
            }).orElse(null),
            onboardingPublicKey = javaType.onboardingPublicKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
