@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The agentPool resource definition
 * @property availabilityZones AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
 * @property cloudProviderProfile The underlying cloud infra provider properties.
 * @property count Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
 * @property extendedLocation
 * @property id Resource Id
 * @property location The resource location
 * @property maxCount The maximum number of nodes for auto-scaling
 * @property maxPods The maximum number of pods that can run on a node.
 * @property minCount The minimum number of nodes for auto-scaling
 * @property mode Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
 * @property name Resource Name
 * @property nodeImageVersion The version of node image
 * @property nodeLabels NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
 * @property nodeTaints NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
 * @property osType OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
 * @property provisioningState
 * @property status HybridAKSNodePoolStatus defines the observed state of HybridAKSNodePool
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags
 * @property type Resource Type
 * @property vmSize VmSize - The size of the agent pool VMs.
 */
public data class GetAgentPoolResult(
    public val availabilityZones: List<String>? = null,
    public val cloudProviderProfile: CloudProviderProfileResponse? = null,
    public val count: Int? = null,
    public val extendedLocation: AgentPoolResponseExtendedLocation? = null,
    public val id: String,
    public val location: String? = null,
    public val maxCount: Int? = null,
    public val maxPods: Int? = null,
    public val minCount: Int? = null,
    public val mode: String? = null,
    public val name: String,
    public val nodeImageVersion: String? = null,
    public val nodeLabels: Map<String, String>? = null,
    public val nodeTaints: List<String>? = null,
    public val osType: String? = null,
    public val provisioningState: String,
    public val status: AgentPoolProvisioningStatusResponseStatus? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmSize: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.GetAgentPoolResult): GetAgentPoolResult = GetAgentPoolResult(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            cloudProviderProfile = javaType.cloudProviderProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.CloudProviderProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.AgentPoolResponseExtendedLocation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            maxCount = javaType.maxCount().map({ args0 -> args0 }).orElse(null),
            maxPods = javaType.maxPods().map({ args0 -> args0 }).orElse(null),
            minCount = javaType.minCount().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            nodeImageVersion = javaType.nodeImageVersion().map({ args0 -> args0 }).orElse(null),
            nodeLabels = javaType.nodeLabels().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            nodeTaints = javaType.nodeTaints().map({ args0 -> args0 }),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.AgentPoolProvisioningStatusResponseStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
