@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * NetworkProfile - Profile of network configuration.
 * @property dnsServiceIP DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
 * @property loadBalancerProfile LoadBalancerProfile - Profile of the cluster load balancer.
 * @property loadBalancerSku LoadBalancerSku - The load balancer sku for the provisioned cluster. Possible values: 'unstacked-haproxy', 'stacked-kube-vip', 'stacked-metallb', 'unmanaged'. The default is 'unmanaged'.
 * @property networkPolicy NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico', 'flannel'. Default is 'calico'
 * @property podCidr PodCidr - A CIDR notation IP range from which to assign pod IPs when kubenet is used.
 * @property podCidrs The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
 * @property serviceCidr ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
 * @property serviceCidrs The CIDR notation IP ranges from which to assign service cluster IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
 */
public data class NetworkProfileResponse(
    public val dnsServiceIP: String? = null,
    public val loadBalancerProfile: LoadBalancerProfileResponse? = null,
    public val loadBalancerSku: String? = null,
    public val networkPolicy: String? = null,
    public val podCidr: String? = null,
    public val podCidrs: List<String>? = null,
    public val serviceCidr: String? = null,
    public val serviceCidrs: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.NetworkProfileResponse): NetworkProfileResponse = NetworkProfileResponse(
            dnsServiceIP = javaType.dnsServiceIP().map({ args0 -> args0 }).orElse(null),
            loadBalancerProfile = javaType.loadBalancerProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.LoadBalancerProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            loadBalancerSku = javaType.loadBalancerSku().map({ args0 -> args0 }).orElse(null),
            networkPolicy = javaType.networkPolicy().map({ args0 -> args0 }).orElse(null),
            podCidr = javaType.podCidr().map({ args0 -> args0 }).orElse(null),
            podCidrs = javaType.podCidrs().map({ args0 -> args0 }),
            serviceCidr = javaType.serviceCidr().map({ args0 -> args0 }).orElse(null),
            serviceCidrs = javaType.serviceCidrs().map({ args0 -> args0 }),
        )
    }
}
