@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains Provisioning errors
 * @property error
 * @property operationId
 * @property phase Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
 * @property status
 */
public data class ProvisionedClustersCommonPropertiesResponseProvisioningStatus(
    public val error: ProvisionedClustersCommonPropertiesResponseError? = null,
    public val operationId: String? = null,
    public val phase: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.ProvisionedClustersCommonPropertiesResponseProvisioningStatus): ProvisionedClustersCommonPropertiesResponseProvisioningStatus =
            ProvisionedClustersCommonPropertiesResponseProvisioningStatus(
                error = javaType.error().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClustersCommonPropertiesResponseError.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                operationId = javaType.operationId().map({ args0 -> args0 }).orElse(null),
                phase = javaType.phase().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
