@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * HybridAKSStorageSpec defines the desired state of HybridAKSStorage
 * @property hciStorageProfile
 * @property provisioningState
 * @property status HybridAKSStorageStatus defines the observed state of HybridAKSStorage
 * @property vmwareStorageProfile
 */
public data class StorageSpacesPropertiesResponse(
    public val hciStorageProfile: StorageSpacesPropertiesResponseHciStorageProfile? = null,
    public val provisioningState: String,
    public val status: StorageSpacesPropertiesResponseStatus? = null,
    public val vmwareStorageProfile: StorageSpacesPropertiesResponseVmwareStorageProfile? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.StorageSpacesPropertiesResponse): StorageSpacesPropertiesResponse = StorageSpacesPropertiesResponse(
            hciStorageProfile = javaType.hciStorageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.StorageSpacesPropertiesResponseHciStorageProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.StorageSpacesPropertiesResponseStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmwareStorageProfile = javaType.vmwareStorageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.StorageSpacesPropertiesResponseVmwareStorageProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
