@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property datacenter Name of the datacenter in VSphere
 * @property datastore Name of the datastore in VSphere
 * @property folder Name of the folder in VSphere
 * @property resourcePool Name of the resource pool in VSphere
 */
public data class StorageSpacesPropertiesResponseVmwareStorageProfile(
    public val datacenter: String? = null,
    public val datastore: String? = null,
    public val folder: String? = null,
    public val resourcePool: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.StorageSpacesPropertiesResponseVmwareStorageProfile): StorageSpacesPropertiesResponseVmwareStorageProfile =
            StorageSpacesPropertiesResponseVmwareStorageProfile(
                datacenter = javaType.datacenter().map({ args0 -> args0 }).orElse(null),
                datastore = javaType.datastore().map({ args0 -> args0 }).orElse(null),
                folder = javaType.folder().map({ args0 -> args0 }).orElse(null),
                resourcePool = javaType.resourcePool().map({ args0 -> args0 }).orElse(null),
            )
    }
}
