@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Infra network profile for HCI platform
 * @property mocGroup Resource group in MOC(Microsoft On-premises Cloud)
 * @property mocLocation Location in MOC(Microsoft On-premises Cloud)
 * @property mocVnetName Virtual Network name in MOC(Microsoft On-premises Cloud)
 */
public data class VirtualNetworksPropertiesResponseHci(
    public val mocGroup: String? = null,
    public val mocLocation: String? = null,
    public val mocVnetName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.VirtualNetworksPropertiesResponseHci): VirtualNetworksPropertiesResponseHci = VirtualNetworksPropertiesResponseHci(
            mocGroup = javaType.mocGroup().map({ args0 -> args0 }).orElse(null),
            mocLocation = javaType.mocLocation().map({ args0 -> args0 }).orElse(null),
            mocVnetName = javaType.mocVnetName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
