@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property hci Infra network profile for HCI platform
 * @property networkCloud Infra network profile for the NetworkCloud platform
 * @property vmware Infra network profile for VMware platform
 */
public data class VirtualNetworksPropertiesResponseInfraVnetProfile(
    public val hci: VirtualNetworksPropertiesResponseHci? = null,
    public val networkCloud: VirtualNetworksPropertiesResponseNetworkCloud? = null,
    public val vmware: VirtualNetworksPropertiesResponseVmware? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.VirtualNetworksPropertiesResponseInfraVnetProfile): VirtualNetworksPropertiesResponseInfraVnetProfile =
            VirtualNetworksPropertiesResponseInfraVnetProfile(
                hci = javaType.hci().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.VirtualNetworksPropertiesResponseHci.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                networkCloud = javaType.networkCloud().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.VirtualNetworksPropertiesResponseNetworkCloud.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                vmware = javaType.vmware().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.VirtualNetworksPropertiesResponseVmware.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
