@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Profile for Windows VMs in the container service cluster.
 * @property adminUsername AdminUsername - Specifies the name of the administrator account. <br><br> **restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
 * @property enableCsiProxy EnableCSIProxy - Whether to enable CSI proxy.
 * @property licenseType LicenseType - The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs. Possible values include: 'None', 'Windows_Server'
 */
public data class WindowsProfileResponseResponse(
    public val adminUsername: String? = null,
    public val enableCsiProxy: Boolean? = null,
    public val licenseType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.WindowsProfileResponseResponse): WindowsProfileResponseResponse = WindowsProfileResponseResponse(
            adminUsername = javaType.adminUsername().map({ args0 -> args0 }).orElse(null),
            enableCsiProxy = javaType.enableCsiProxy().map({ args0 -> args0 }).orElse(null),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
