@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin

import com.pulumi.azurenative.hybriddata.HybriddataFunctions.getDataManagerPlain
import com.pulumi.azurenative.hybriddata.HybriddataFunctions.getDataStorePlain
import com.pulumi.azurenative.hybriddata.HybriddataFunctions.getJobDefinitionPlain
import com.pulumi.azurenative.hybriddata.kotlin.inputs.GetDataManagerPlainArgs
import com.pulumi.azurenative.hybriddata.kotlin.inputs.GetDataManagerPlainArgsBuilder
import com.pulumi.azurenative.hybriddata.kotlin.inputs.GetDataStorePlainArgs
import com.pulumi.azurenative.hybriddata.kotlin.inputs.GetDataStorePlainArgsBuilder
import com.pulumi.azurenative.hybriddata.kotlin.inputs.GetJobDefinitionPlainArgs
import com.pulumi.azurenative.hybriddata.kotlin.inputs.GetJobDefinitionPlainArgsBuilder
import com.pulumi.azurenative.hybriddata.kotlin.outputs.GetDataManagerResult
import com.pulumi.azurenative.hybriddata.kotlin.outputs.GetDataStoreResult
import com.pulumi.azurenative.hybriddata.kotlin.outputs.GetJobDefinitionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.hybriddata.kotlin.outputs.GetDataManagerResult.Companion.toKotlin as getDataManagerResultToKotlin
import com.pulumi.azurenative.hybriddata.kotlin.outputs.GetDataStoreResult.Companion.toKotlin as getDataStoreResultToKotlin
import com.pulumi.azurenative.hybriddata.kotlin.outputs.GetJobDefinitionResult.Companion.toKotlin as getJobDefinitionResultToKotlin

public object HybriddataFunctions {
    /**
     * Gets information about the specified data manager resource.
     * Azure REST API version: 2019-06-01.
     * @param argument null
     * @return The DataManager resource.
     */
    public suspend fun getDataManager(argument: GetDataManagerPlainArgs): GetDataManagerResult =
        getDataManagerResultToKotlin(getDataManagerPlain(argument.toJava()).await())

    /**
     * @see [getDataManager].
     * @param dataManagerName The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     * @param resourceGroupName The Resource Group Name
     * @return The DataManager resource.
     */
    public suspend fun getDataManager(dataManagerName: String, resourceGroupName: String): GetDataManagerResult {
        val argument = GetDataManagerPlainArgs(
            dataManagerName = dataManagerName,
            resourceGroupName = resourceGroupName,
        )
        return getDataManagerResultToKotlin(getDataManagerPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataManager].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybriddata&#46;kotlin&#46;inputs&#46;GetDataManagerPlainArgs].
     * @return The DataManager resource.
     */
    public suspend fun getDataManager(argument: suspend GetDataManagerPlainArgsBuilder.() -> Unit): GetDataManagerResult {
        val builder = GetDataManagerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataManagerResultToKotlin(getDataManagerPlain(builtArgument.toJava()).await())
    }

    /**
     * This method gets the data store/repository by name.
     * Azure REST API version: 2019-06-01.
     * @param argument null
     * @return Data store.
     */
    public suspend fun getDataStore(argument: GetDataStorePlainArgs): GetDataStoreResult =
        getDataStoreResultToKotlin(getDataStorePlain(argument.toJava()).await())

    /**
     * @see [getDataStore].
     * @param dataManagerName The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     * @param dataStoreName The data store/repository name queried.
     * @param resourceGroupName The Resource Group Name
     * @return Data store.
     */
    public suspend fun getDataStore(
        dataManagerName: String,
        dataStoreName: String,
        resourceGroupName: String,
    ): GetDataStoreResult {
        val argument = GetDataStorePlainArgs(
            dataManagerName = dataManagerName,
            dataStoreName = dataStoreName,
            resourceGroupName = resourceGroupName,
        )
        return getDataStoreResultToKotlin(getDataStorePlain(argument.toJava()).await())
    }

    /**
     * @see [getDataStore].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybriddata&#46;kotlin&#46;inputs&#46;GetDataStorePlainArgs].
     * @return Data store.
     */
    public suspend fun getDataStore(argument: suspend GetDataStorePlainArgsBuilder.() -> Unit): GetDataStoreResult {
        val builder = GetDataStorePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataStoreResultToKotlin(getDataStorePlain(builtArgument.toJava()).await())
    }

    /**
     * This method gets job definition object by name.
     * Azure REST API version: 2019-06-01.
     * @param argument null
     * @return Job Definition.
     */
    public suspend fun getJobDefinition(argument: GetJobDefinitionPlainArgs): GetJobDefinitionResult =
        getJobDefinitionResultToKotlin(getJobDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getJobDefinition].
     * @param dataManagerName The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     * @param dataServiceName The data service name of the job definition
     * @param jobDefinitionName The job definition name that is being queried.
     * @param resourceGroupName The Resource Group Name
     * @return Job Definition.
     */
    public suspend fun getJobDefinition(
        dataManagerName: String,
        dataServiceName: String,
        jobDefinitionName: String,
        resourceGroupName: String,
    ): GetJobDefinitionResult {
        val argument = GetJobDefinitionPlainArgs(
            dataManagerName = dataManagerName,
            dataServiceName = dataServiceName,
            jobDefinitionName = jobDefinitionName,
            resourceGroupName = resourceGroupName,
        )
        return getJobDefinitionResultToKotlin(getJobDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getJobDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybriddata&#46;kotlin&#46;inputs&#46;GetJobDefinitionPlainArgs].
     * @return Job Definition.
     */
    public suspend fun getJobDefinition(argument: suspend GetJobDefinitionPlainArgsBuilder.() -> Unit): GetJobDefinitionResult {
        val builder = GetJobDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobDefinitionResultToKotlin(getJobDefinitionPlain(builtArgument.toJava()).await())
    }
}
