@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.inputs

import com.pulumi.azurenative.hybriddata.inputs.GetDataStorePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataManagerName The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
 * @property dataStoreName The data store/repository name queried.
 * @property resourceGroupName The Resource Group Name
 */
public data class GetDataStorePlainArgs(
    public val dataManagerName: String,
    public val dataStoreName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybriddata.inputs.GetDataStorePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybriddata.inputs.GetDataStorePlainArgs =
        com.pulumi.azurenative.hybriddata.inputs.GetDataStorePlainArgs.builder()
            .dataManagerName(dataManagerName.let({ args0 -> args0 }))
            .dataStoreName(dataStoreName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataStorePlainArgs].
 */
@PulumiTagMarker
public class GetDataStorePlainArgsBuilder internal constructor() {
    private var dataManagerName: String? = null

    private var dataStoreName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("uxqkfutyuwnmumyi")
    public suspend fun dataManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataManagerName = mapped
    }

    /**
     * @param value The data store/repository name queried.
     */
    @JvmName("sothygnxeypqwwly")
    public suspend fun dataStoreName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataStoreName = mapped
    }

    /**
     * @param value The Resource Group Name
     */
    @JvmName("kcghbpforoldxuks")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataStorePlainArgs = GetDataStorePlainArgs(
        dataManagerName = dataManagerName ?: throw PulumiNullFieldException("dataManagerName"),
        dataStoreName = dataStoreName ?: throw PulumiNullFieldException("dataStoreName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
