@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.inputs

import com.pulumi.azurenative.hybriddata.inputs.SkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The sku type.
 * @property name The sku name. Required for data manager creation, optional for update.
 * @property tier The sku tier. This is based on the SKU name.
 */
public data class SkuArgs(
    public val name: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybriddata.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.hybriddata.inputs.SkuArgs =
        com.pulumi.azurenative.hybriddata.inputs.SkuArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value The sku name. Required for data manager creation, optional for update.
     */
    @JvmName("ecedgsaokpostyyf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The sku tier. This is based on the SKU name.
     */
    @JvmName("smwbpustpmemtlou")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The sku name. Required for data manager creation, optional for update.
     */
    @JvmName("uneytmgmlojnsbhs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku tier. This is based on the SKU name.
     */
    @JvmName("upkcgpirbudmkvhm")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name,
        tier = tier,
    )
}
