@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The pair of customer secret.
 * @property algorithm The encryption algorithm used to encrypt data.
 * @property keyIdentifier The identifier to the data service input object which this secret corresponds to.
 * @property keyValue It contains the encrypted customer secret.
 */
public data class CustomerSecretResponse(
    public val algorithm: String,
    public val keyIdentifier: String,
    public val keyValue: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybriddata.outputs.CustomerSecretResponse): CustomerSecretResponse = CustomerSecretResponse(
            algorithm = javaType.algorithm(),
            keyIdentifier = javaType.keyIdentifier(),
            keyValue = javaType.keyValue(),
        )
    }
}
