@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Job Definition.
 * @property customerSecrets List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
 * @property dataServiceInput A generic json used differently by each data service type.
 * @property dataSinkId Data Sink Id associated to the job definition.
 * @property dataSourceId Data Source Id associated to the job definition.
 * @property id Id of the object.
 * @property lastModifiedTime Last modified time of the job definition.
 * @property name Name of the object.
 * @property runLocation This is the preferred geo location for the job to run.
 * @property schedules Schedule for running the job definition
 * @property state State of the job definition.
 * @property type Type of the object.
 * @property userConfirmation Enum to detect if user confirmation is required. If not passed will default to NotRequired.
 */
public data class GetJobDefinitionResult(
    public val customerSecrets: List<CustomerSecretResponse>? = null,
    public val dataServiceInput: Any? = null,
    public val dataSinkId: String,
    public val dataSourceId: String,
    public val id: String,
    public val lastModifiedTime: String? = null,
    public val name: String,
    public val runLocation: String? = null,
    public val schedules: List<ScheduleResponse>? = null,
    public val state: String,
    public val type: String,
    public val userConfirmation: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybriddata.outputs.GetJobDefinitionResult): GetJobDefinitionResult = GetJobDefinitionResult(
            customerSecrets = javaType.customerSecrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybriddata.kotlin.outputs.CustomerSecretResponse.Companion.toKotlin(args0)
                })
            }),
            dataServiceInput = javaType.dataServiceInput().map({ args0 -> args0 }).orElse(null),
            dataSinkId = javaType.dataSinkId(),
            dataSourceId = javaType.dataSourceId(),
            id = javaType.id(),
            lastModifiedTime = javaType.lastModifiedTime().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            runLocation = javaType.runLocation().map({ args0 -> args0 }).orElse(null),
            schedules = javaType.schedules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybriddata.kotlin.outputs.ScheduleResponse.Companion.toKotlin(args0)
                })
            }),
            state = javaType.state(),
            type = javaType.type(),
            userConfirmation = javaType.userConfirmation().map({ args0 -> args0 }).orElse(null),
        )
    }
}
