@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Schedule for the job run.
 * @property name Name of the schedule.
 * @property policyList A list of repetition intervals in ISO 8601 format.
 */
public data class ScheduleResponse(
    public val name: String? = null,
    public val policyList: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybriddata.outputs.ScheduleResponse): ScheduleResponse = ScheduleResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            policyList = javaType.policyList().map({ args0 -> args0 }),
        )
    }
}
