@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ArtifactStorePropertiesFormatResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ArtifactStorePropertiesFormatResponse.Companion.toKotlin as artifactStorePropertiesFormatResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ArtifactStore].
 */
@PulumiTagMarker
public class ArtifactStoreResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ArtifactStoreArgs = ArtifactStoreArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ArtifactStoreArgsBuilder.() -> Unit) {
        val builder = ArtifactStoreArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ArtifactStore {
        val builtJavaResource =
            com.pulumi.azurenative.hybridnetwork.ArtifactStore(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ArtifactStore(builtJavaResource)
    }
}

/**
 * Artifact store properties.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update an artifact store of publisher resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var artifactStore = new AzureNative.HybridNetwork.ArtifactStore("artifactStore", new()
 *     {
 *         ArtifactStoreName = "TestArtifactStore",
 *         Location = "eastus",
 *         Properties = new AzureNative.HybridNetwork.Inputs.ArtifactStorePropertiesFormatArgs
 *         {
 *             ManagedResourceGroupConfiguration = new AzureNative.HybridNetwork.Inputs.ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs
 *             {
 *                 Location = "eastus",
 *                 Name = "testRg",
 *             },
 *             ReplicationStrategy = AzureNative.HybridNetwork.ArtifactReplicationStrategy.SingleReplication,
 *             StoreType = AzureNative.HybridNetwork.ArtifactStoreType.AzureContainerRegistry,
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewArtifactStore(ctx, "artifactStore", &hybridnetwork.ArtifactStoreArgs{
 * 			ArtifactStoreName: pulumi.String("TestArtifactStore"),
 * 			Location:          pulumi.String("eastus"),
 * 			Properties: &hybridnetwork.ArtifactStorePropertiesFormatArgs{
 * 				ManagedResourceGroupConfiguration: &hybridnetwork.ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs{
 * 					Location: pulumi.String("eastus"),
 * 					Name:     pulumi.String("testRg"),
 * 				},
 * 				ReplicationStrategy: pulumi.String(hybridnetwork.ArtifactReplicationStrategySingleReplication),
 * 				StoreType:           pulumi.String(hybridnetwork.ArtifactStoreTypeAzureContainerRegistry),
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.ArtifactStore;
 * import com.pulumi.azurenative.hybridnetwork.ArtifactStoreArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.ArtifactStorePropertiesFormatArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var artifactStore = new ArtifactStore("artifactStore", ArtifactStoreArgs.builder()
 *             .artifactStoreName("TestArtifactStore")
 *             .location("eastus")
 *             .properties(ArtifactStorePropertiesFormatArgs.builder()
 *                 .managedResourceGroupConfiguration(ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs.builder()
 *                     .location("eastus")
 *                     .name("testRg")
 *                     .build())
 *                 .replicationStrategy("SingleReplication")
 *                 .storeType("AzureContainerRegistry")
 *                 .build())
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:ArtifactStore TestArtifactStore /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}
 * ```
 */
public class ArtifactStore internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.ArtifactStore,
) : KotlinCustomResource(javaResource, ArtifactStoreMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ArtifactStores properties.
     */
    public val properties: Output<ArtifactStorePropertiesFormatResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                artifactStorePropertiesFormatResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ArtifactStoreMapper : ResourceMapper<ArtifactStore> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.ArtifactStore::class == javaResource::class

    override fun map(javaResource: Resource): ArtifactStore = ArtifactStore(
        javaResource as
            com.pulumi.azurenative.hybridnetwork.ArtifactStore,
    )
}

/**
 * @see [ArtifactStore].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ArtifactStore].
 */
public suspend fun artifactStore(
    name: String,
    block: suspend ArtifactStoreResourceBuilder.() -> Unit,
): ArtifactStore {
    val builder = ArtifactStoreResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ArtifactStore].
 * @param name The _unique_ name of the resulting resource.
 */
public fun artifactStore(name: String): ArtifactStore {
    val builder = ArtifactStoreResourceBuilder()
    builder.name(name)
    return builder.build()
}
