@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ConfigurationGroupSchemaPropertiesFormatResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ConfigurationGroupSchemaPropertiesFormatResponse.Companion.toKotlin as configurationGroupSchemaPropertiesFormatResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConfigurationGroupSchema].
 */
@PulumiTagMarker
public class ConfigurationGroupSchemaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationGroupSchemaArgs = ConfigurationGroupSchemaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationGroupSchemaArgsBuilder.() -> Unit) {
        val builder = ConfigurationGroupSchemaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConfigurationGroupSchema {
        val builtJavaResource =
            com.pulumi.azurenative.hybridnetwork.ConfigurationGroupSchema(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationGroupSchema(builtJavaResource)
    }
}

/**
 * Configuration group schema resource.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update the network function definition group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationGroupSchema = new AzureNative.HybridNetwork.ConfigurationGroupSchema("configurationGroupSchema", new()
 *     {
 *         ConfigurationGroupSchemaName = "testConfigurationGroupSchema",
 *         Location = "westUs2",
 *         Properties = new AzureNative.HybridNetwork.Inputs.ConfigurationGroupSchemaPropertiesFormatArgs
 *         {
 *             Description = "Schema with no secrets",
 *             SchemaDefinition = "{\"type\":\"object\",\"properties\":{\"interconnect-groups\":{\"type\":\"object\",\"properties\":{\"type\":\"object\",\"properties\":{\"name\":{\"type\":\"string\"},\"international-interconnects\":{\"type\":\"array\",\"item\":{\"type\":\"string\"}},\"domestic-interconnects\":{\"type\":\"array\",\"item\":{\"type\":\"string\"}}}}},\"interconnect-group-assignments\":{\"type\":\"object\",\"properties\":{\"type\":\"object\",\"properties\":{\"ssc\":{\"type\":\"string\"},\"interconnects-interconnects\":{\"type\":\"string\"}}}}},\"required\":[\"interconnect-groups\",\"interconnect-group-assignments\"]}",
 *         },
 *         PublisherName = "testPublisher",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewConfigurationGroupSchema(ctx, "configurationGroupSchema", &hybridnetwork.ConfigurationGroupSchemaArgs{
 * 			ConfigurationGroupSchemaName: pulumi.String("testConfigurationGroupSchema"),
 * 			Location:                     pulumi.String("westUs2"),
 * 			Properties: &hybridnetwork.ConfigurationGroupSchemaPropertiesFormatArgs{
 * 				Description:      pulumi.String("Schema with no secrets"),
 * 				SchemaDefinition: pulumi.String("{\"type\":\"object\",\"properties\":{\"interconnect-groups\":{\"type\":\"object\",\"properties\":{\"type\":\"object\",\"properties\":{\"name\":{\"type\":\"string\"},\"international-interconnects\":{\"type\":\"array\",\"item\":{\"type\":\"string\"}},\"domestic-interconnects\":{\"type\":\"array\",\"item\":{\"type\":\"string\"}}}}},\"interconnect-group-assignments\":{\"type\":\"object\",\"properties\":{\"type\":\"object\",\"properties\":{\"ssc\":{\"type\":\"string\"},\"interconnects-interconnects\":{\"type\":\"string\"}}}}},\"required\":[\"interconnect-groups\",\"interconnect-group-assignments\"]}"),
 * 			},
 * 			PublisherName:     pulumi.String("testPublisher"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.ConfigurationGroupSchema;
 * import com.pulumi.azurenative.hybridnetwork.ConfigurationGroupSchemaArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationGroupSchemaPropertiesFormatArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationGroupSchema = new ConfigurationGroupSchema("configurationGroupSchema", ConfigurationGroupSchemaArgs.builder()
 *             .configurationGroupSchemaName("testConfigurationGroupSchema")
 *             .location("westUs2")
 *             .properties(ConfigurationGroupSchemaPropertiesFormatArgs.builder()
 *                 .description("Schema with no secrets")
 *                 .schemaDefinition("{\"type\":\"object\",\"properties\":{\"interconnect-groups\":{\"type\":\"object\",\"properties\":{\"type\":\"object\",\"properties\":{\"name\":{\"type\":\"string\"},\"international-interconnects\":{\"type\":\"array\",\"item\":{\"type\":\"string\"}},\"domestic-interconnects\":{\"type\":\"array\",\"item\":{\"type\":\"string\"}}}}},\"interconnect-group-assignments\":{\"type\":\"object\",\"properties\":{\"type\":\"object\",\"properties\":{\"ssc\":{\"type\":\"string\"},\"interconnects-interconnects\":{\"type\":\"string\"}}}}},\"required\":[\"interconnect-groups\",\"interconnect-group-assignments\"]}")
 *                 .build())
 *             .publisherName("testPublisher")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:ConfigurationGroupSchema testConfigurationGroupSchema /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}
 * ```
 */
public class ConfigurationGroupSchema internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.ConfigurationGroupSchema,
) : KotlinCustomResource(javaResource, ConfigurationGroupSchemaMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration group schema properties.
     */
    public val properties: Output<ConfigurationGroupSchemaPropertiesFormatResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                configurationGroupSchemaPropertiesFormatResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationGroupSchemaMapper : ResourceMapper<ConfigurationGroupSchema> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.ConfigurationGroupSchema::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationGroupSchema =
        ConfigurationGroupSchema(
            javaResource as
                com.pulumi.azurenative.hybridnetwork.ConfigurationGroupSchema,
        )
}

/**
 * @see [ConfigurationGroupSchema].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationGroupSchema].
 */
public suspend fun configurationGroupSchema(
    name: String,
    block: suspend ConfigurationGroupSchemaResourceBuilder.() -> Unit,
): ConfigurationGroupSchema {
    val builder = ConfigurationGroupSchemaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationGroupSchema].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationGroupSchema(name: String): ConfigurationGroupSchema {
    val builder = ConfigurationGroupSchemaResourceBuilder()
    builder.name(name)
    return builder.build()
}
